/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.eq;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.ObjList;

public class EqDoubleFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "=(DD)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function left = args.getQuick(0);
        Function right = args.getQuick(1);
        if (left.isConstant() && left.getType() == 9 && Double.isNaN(left.getDouble(null))) {
            switch (right.getType()) {
                case 4: {
                    return new FuncIntIsNaN(position, right);
                }
                case 5: {
                    return new FuncLongIsNaN(position, right);
                }
                case 6: {
                    return new FuncDateIsNaN(position, right);
                }
                case 7: {
                    return new FuncTimestampIsNaN(position, right);
                }
                case 8: {
                    return new FuncFloatIsNaN(position, right);
                }
            }
            return new FuncDoubleIsNaN(position, right);
        }
        if (right.isConstant() && right.getType() == 9 && Double.isNaN(right.getDouble(null))) {
            switch (left.getType()) {
                case 4: {
                    return new FuncIntIsNaN(position, left);
                }
                case 5: {
                    return new FuncLongIsNaN(position, left);
                }
                case 6: {
                    return new FuncDateIsNaN(position, left);
                }
                case 7: {
                    return new FuncTimestampIsNaN(position, left);
                }
                case 8: {
                    return new FuncFloatIsNaN(position, left);
                }
            }
            return new FuncDoubleIsNaN(position, left);
        }
        return new Func(position, args.getQuick(0), args.getQuick(1));
    }

    protected static class FuncDoubleIsNaN
    extends NegatableBooleanFunction
    implements UnaryFunction {
        protected final Function arg;

        public FuncDoubleIsNaN(int position, Function arg) {
            super(position);
            this.arg = arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != Double.isNaN(this.arg.getDouble(rec));
        }

        @Override
        public Function getArg() {
            return this.arg;
        }
    }

    protected static class FuncFloatIsNaN
    extends NegatableBooleanFunction
    implements UnaryFunction {
        protected final Function arg;

        public FuncFloatIsNaN(int position, Function arg) {
            super(position);
            this.arg = arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != Float.isNaN(this.arg.getFloat(rec));
        }

        @Override
        public Function getArg() {
            return this.arg;
        }
    }

    protected static class FuncTimestampIsNaN
    extends NegatableBooleanFunction
    implements UnaryFunction {
        protected final Function arg;

        public FuncTimestampIsNaN(int position, Function arg) {
            super(position);
            this.arg = arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != (this.arg.getTimestamp(rec) == Long.MIN_VALUE);
        }

        @Override
        public Function getArg() {
            return this.arg;
        }
    }

    protected static class FuncDateIsNaN
    extends NegatableBooleanFunction
    implements UnaryFunction {
        protected final Function arg;

        public FuncDateIsNaN(int position, Function arg) {
            super(position);
            this.arg = arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != (this.arg.getDate(rec) == Long.MIN_VALUE);
        }

        @Override
        public Function getArg() {
            return this.arg;
        }
    }

    protected static class FuncLongIsNaN
    extends NegatableBooleanFunction
    implements UnaryFunction {
        protected final Function arg;

        public FuncLongIsNaN(int position, Function arg) {
            super(position);
            this.arg = arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != (this.arg.getLong(rec) == Long.MIN_VALUE);
        }

        @Override
        public Function getArg() {
            return this.arg;
        }
    }

    protected static class FuncIntIsNaN
    extends NegatableBooleanFunction
    implements UnaryFunction {
        protected final Function arg;

        public FuncIntIsNaN(int position, Function arg) {
            super(position);
            this.arg = arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != (this.arg.getInt(rec) == Integer.MIN_VALUE);
        }

        @Override
        public Function getArg() {
            return this.arg;
        }
    }

    protected static class Func
    extends NegatableBooleanFunction
    implements BinaryFunction {
        protected final Function left;
        protected final Function right;

        public Func(int position, Function left, Function right) {
            super(position);
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean getBool(Record rec) {
            double l = this.left.getDouble(rec);
            double r = this.right.getDouble(rec);
            return this.negated != (l != l && r != r || Math.abs(l - r) < 1.0E-10);
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public Function getRight() {
            return this.right;
        }
    }
}

