/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.eq;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.ConstantFunction;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;

public class EqIntStrCFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "=(Is)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        try {
            CharSequence value = args.getQuick(1).getStr(null);
            if (value == null) {
                return new Func(position, args.getQuick(0), Integer.MIN_VALUE);
            }
            return new Func(position, args.getQuick(0), Numbers.parseInt(value));
        }
        catch (NumericException e) {
            return new NegatedAwareBooleanConstantFunc(args.getQuick(1).getPosition());
        }
    }

    private static class NegatedAwareBooleanConstantFunc
    extends NegatableBooleanFunction
    implements ConstantFunction {
        public NegatedAwareBooleanConstantFunc(int position) {
            super(position);
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated;
        }
    }

    private static class Func
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final Function left;
        private final int right;

        public Func(int position, Function left, int right) {
            super(position);
            this.left = left;
            this.right = right;
        }

        @Override
        public Function getArg() {
            return this.left;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != (this.left.getInt(rec) == this.right);
        }
    }
}

