/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.eq;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.Long256;
import io.questdb.std.Long256FromCharSequenceDecoder;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;

public class EqLong256StrFunctionFactory
implements FunctionFactory {
    private static final ThreadLocal<Long256Decoder> DECODER = ThreadLocal.withInitial(() -> new Long256Decoder());

    @Override
    public String getSignature() {
        return "=(Hs)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        CharSequence hexLong256 = args.getQuick(1).getStr(null);
        try {
            return EqLong256StrFunctionFactory.DECODER.get().newInstance(position, args.getQuick(0), hexLong256);
        }
        catch (NumericException e) {
            throw SqlException.position(args.getQuick(1).getPosition()).put("invalid hex value for long256");
        }
    }

    private static class Long256Decoder
    extends Long256FromCharSequenceDecoder {
        private long long0;
        private long long1;
        private long long2;
        private long long3;

        private Long256Decoder() {
        }

        @Override
        public void onDecoded(long l0, long l1, long l2, long l3) {
            this.long0 = l0;
            this.long1 = l1;
            this.long2 = l2;
            this.long3 = l3;
        }

        private Func newInstance(int position, Function arg, CharSequence hexLong256) throws NumericException {
            Long256Decoder.decode(hexLong256, 2, hexLong256.length(), this);
            return new Func(position, arg, this.long0, this.long1, this.long2, this.long3);
        }
    }

    private static class Func
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final Function arg;
        private final long long0;
        private final long long1;
        private final long long2;
        private final long long3;

        public Func(int position, Function arg, long long0, long long1, long long2, long long3) {
            super(position);
            this.arg = arg;
            this.long0 = long0;
            this.long1 = long1;
            this.long2 = long2;
            this.long3 = long3;
        }

        @Override
        public boolean getBool(Record rec) {
            Long256 value = this.arg.getLong256A(rec);
            return this.negated != (value.getLong0() == this.long0 && value.getLong1() == this.long1 && value.getLong2() == this.long2 && value.getLong3() == this.long3);
        }

        @Override
        public Function getArg() {
            return this.arg;
        }
    }
}

