/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.LongFunction;

public class CountGroupByFunction
extends LongFunction
implements GroupByFunction {
    private int valueIndex;

    public CountGroupByFunction(int position) {
        super(position);
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record) {
        mapValue.putLong(this.valueIndex, 1L);
    }

    @Override
    public void computeNext(MapValue mapValue, Record record) {
        mapValue.addLong(this.valueIndex, 1L);
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(5);
    }

    @Override
    public void setLong(MapValue mapValue, long value) {
        mapValue.putLong(this.valueIndex, value);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putLong(this.valueIndex, Long.MIN_VALUE);
    }

    @Override
    public long getLong(Record rec) {
        return rec.getLong(this.valueIndex);
    }

    @Override
    public boolean isConstant() {
        return false;
    }
}

