/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.std.Long256;
import io.questdb.std.Long256HashSet;
import io.questdb.std.ObjList;

public class CountLong256GroupByFunction
extends LongFunction
implements GroupByFunction {
    private final Function arg;
    private final ObjList<Long256HashSet> sets = new ObjList();
    private int valueIndex;
    private int setIndex;

    public CountLong256GroupByFunction(int position, Function arg) {
        super(position);
        this.arg = arg;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record) {
        Long256HashSet set;
        if (this.sets.size() <= this.setIndex) {
            set = new Long256HashSet();
            this.sets.extendAndSet(this.setIndex, set);
        } else {
            set = this.sets.getQuick(this.setIndex);
        }
        set.clear();
        Long256 val = this.arg.getLong256A(record);
        set.add(val.getLong0(), val.getLong1(), val.getLong2(), val.getLong3());
        mapValue.putLong(this.valueIndex, 1L);
        mapValue.putInt(this.valueIndex + 1, this.setIndex++);
    }

    @Override
    public void computeNext(MapValue mapValue, Record record) {
        Long256 val;
        Long256HashSet set = this.sets.getQuick(mapValue.getInt(this.valueIndex + 1));
        int index = set.keyIndex((val = this.arg.getLong256A(record)).getLong0(), val.getLong1(), val.getLong2(), val.getLong3());
        if (index < 0) {
            return;
        }
        set.addAt(index, val.getLong0(), val.getLong1(), val.getLong2(), val.getLong3());
        mapValue.addLong(this.valueIndex, 1L);
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(5);
        columnTypes.add(4);
    }

    @Override
    public void setLong(MapValue mapValue, long value) {
        mapValue.putLong(this.valueIndex, value);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putLong(this.valueIndex, Long.MIN_VALUE);
    }

    @Override
    public long getLong(Record rec) {
        return rec.getLong(this.valueIndex);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public void toTop() {
        this.setIndex = 0;
    }
}

