/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class CountSymbolGroupByFunction
extends LongFunction
implements GroupByFunction {
    private final Function arg;
    private final ObjList<IntList> sets = new ObjList();
    private int valueIndex;
    private int setIndex;

    public CountSymbolGroupByFunction(int position, Function arg) {
        super(position);
        this.arg = arg;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record) {
        IntList set;
        if (this.sets.size() <= this.setIndex) {
            set = new IntList();
            this.sets.extendAndSet(this.setIndex, set);
        } else {
            set = this.sets.getQuick(this.setIndex);
        }
        set.clear(0);
        int val = this.arg.getInt(record);
        set.extendAndSet(val, 1);
        mapValue.putLong(this.valueIndex, 1L);
        mapValue.putInt(this.valueIndex + 1, this.setIndex);
        ++this.setIndex;
    }

    @Override
    public void computeNext(MapValue mapValue, Record record) {
        IntList set = this.sets.getQuick(mapValue.getInt(this.valueIndex + 1));
        int val = this.arg.getInt(record);
        if (val < set.size()) {
            if (set.getQuick(val) == 1) {
                return;
            }
            set.setQuick(val, 1);
        } else {
            set.extendAndSet(val, 1);
        }
        mapValue.addLong(this.valueIndex, 1L);
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(5);
        columnTypes.add(4);
    }

    @Override
    public void setLong(MapValue mapValue, long value) {
        mapValue.putLong(this.valueIndex, value);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putLong(this.valueIndex, Long.MIN_VALUE);
    }

    @Override
    public long getLong(Record rec) {
        return rec.getLong(this.valueIndex);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public void toTop() {
        this.setIndex = 0;
    }
}

