/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import org.jetbrains.annotations.NotNull;

public class FirstSymbolGroupByFunction
extends SymbolFunction
implements GroupByFunction,
UnaryFunction {
    private final SymbolFunction arg;
    private int valueIndex;

    public FirstSymbolGroupByFunction(int position, @NotNull SymbolFunction arg) {
        super(position);
        this.arg = arg;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record) {
        mapValue.putInt(this.valueIndex, this.arg.getInt(record));
    }

    @Override
    public void computeNext(MapValue mapValue, Record record) {
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(4);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putInt(this.valueIndex, Integer.MIN_VALUE);
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public int getInt(Record rec) {
        return rec.getInt(this.valueIndex);
    }

    @Override
    public CharSequence getSymbol(Record rec) {
        return this.arg.valueOf(this.getInt(rec));
    }

    @Override
    public CharSequence getSymbolB(Record rec) {
        return this.arg.valueBOf(this.getInt(rec));
    }

    @Override
    public boolean isSymbolTableStatic() {
        return this.arg.isSymbolTableStatic();
    }

    @Override
    public CharSequence valueOf(int key) {
        return this.arg.valueOf(key);
    }

    @Override
    public CharSequence valueBOf(int key) {
        return this.arg.valueBOf(key);
    }
}

