/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import org.jetbrains.annotations.NotNull;

public class IsLongOrderedGroupByFunction
extends BooleanFunction
implements GroupByFunction,
UnaryFunction {
    private final Function arg;
    private int valueIndex;
    private int flagIndex;

    public IsLongOrderedGroupByFunction(int position, @NotNull Function arg) {
        super(position);
        this.arg = arg;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record) {
        mapValue.putBool(this.flagIndex, true);
        mapValue.putLong(this.valueIndex, this.arg.getLong(record));
    }

    @Override
    public void computeNext(MapValue mapValue, Record record) {
        if (mapValue.getBool(this.flagIndex)) {
            long prev = mapValue.getLong(this.valueIndex);
            long curr = this.arg.getLong(record);
            if (curr < prev) {
                mapValue.putBool(this.flagIndex, false);
            } else {
                mapValue.putLong(this.valueIndex, curr);
            }
        }
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes columnTypes) {
        this.flagIndex = columnTypes.getColumnCount();
        this.valueIndex = this.flagIndex + 1;
        columnTypes.add(0);
        columnTypes.add(5);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putBool(this.flagIndex, true);
    }

    @Override
    public boolean getBool(Record rec) {
        return rec.getBool(this.flagIndex);
    }

    @Override
    public Function getArg() {
        return this.arg;
    }
}

