/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import org.jetbrains.annotations.NotNull;

public class MaxTimestampGroupByFunction
extends TimestampFunction
implements GroupByFunction,
UnaryFunction {
    private final Function arg;
    private int valueIndex;

    public MaxTimestampGroupByFunction(int position, @NotNull Function arg) {
        super(position);
        this.arg = arg;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record) {
        mapValue.putTimestamp(this.valueIndex, this.arg.getTimestamp(record));
    }

    @Override
    public void computeNext(MapValue mapValue, Record record) {
        long max = mapValue.getTimestamp(this.valueIndex);
        long next = this.arg.getTimestamp(record);
        if (next > max) {
            mapValue.putTimestamp(this.valueIndex, next);
        }
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(7);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putTimestamp(this.valueIndex, Long.MIN_VALUE);
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public long getTimestamp(Record rec) {
        return rec.getTimestamp(this.valueIndex);
    }
}

