/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.Numbers;
import org.jetbrains.annotations.NotNull;

public class NSumDoubleGroupByFunction
extends DoubleFunction
implements GroupByFunction,
UnaryFunction {
    private final Function arg;
    private int valueIndex;

    public NSumDoubleGroupByFunction(int position, @NotNull Function arg) {
        super(position);
        this.arg = arg;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record) {
        double value = this.arg.getDouble(record);
        if (Numbers.isFinite(value)) {
            this.sum(mapValue, value, 0.0, 0.0);
            mapValue.putLong(this.valueIndex + 2, 1L);
        } else {
            mapValue.putDouble(this.valueIndex, 0.0);
            mapValue.putDouble(this.valueIndex + 1, 0.0);
            mapValue.putLong(this.valueIndex + 2, 0L);
        }
    }

    @Override
    public void computeNext(MapValue mapValue, Record record) {
        double value = this.arg.getDouble(record);
        if (Numbers.isFinite(value)) {
            this.sum(mapValue, value, mapValue.getDouble(this.valueIndex), mapValue.getDouble(this.valueIndex + 1));
            mapValue.addLong(this.valueIndex + 2, 1L);
        }
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(9);
        columnTypes.add(9);
        columnTypes.add(5);
    }

    @Override
    public void setDouble(MapValue mapValue, double value) {
        mapValue.putDouble(this.valueIndex, value);
        mapValue.putLong(this.valueIndex + 2, 1L);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putDouble(this.valueIndex, Double.NaN);
        mapValue.putLong(this.valueIndex + 2, 0L);
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public double getDouble(Record rec) {
        return rec.getLong(this.valueIndex + 2) > 0L ? rec.getDouble(this.valueIndex) + rec.getDouble(this.valueIndex + 1) : Double.NaN;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    private void sum(MapValue mapValue, double value, double sum, double c) {
        double t = sum + value;
        c = Math.abs(sum) >= Math.abs(value) ? (c += sum - t + value) : (c += value - t + sum);
        mapValue.putDouble(this.valueIndex, t);
        mapValue.putDouble(this.valueIndex + 1, c);
    }
}

