/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.std.ObjList;
import io.questdb.std.str.DirectCharSink;

public class StringAggGroupByFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "string_agg(Sa)";
    }

    @Override
    public boolean isGroupBy() {
        return true;
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new StringAggGroupByFunction(position, args.getQuick(0), args.getQuick(1).getChar(null));
    }

    private static class StringAggGroupByFunction
    extends StrFunction
    implements GroupByFunction {
        private static final int INITIAL_SINK_CAPACITY = 8192;
        private final Function arg;
        private final char delimiter;
        private final DirectCharSink sink = new DirectCharSink(8192L);
        private boolean nullValue = true;

        public StringAggGroupByFunction(int position, Function arg, char delimiter) {
            super(position);
            this.arg = arg;
            this.delimiter = delimiter;
        }

        @Override
        public void computeFirst(MapValue mapValue, Record record) {
            this.setNull();
            CharSequence str = this.arg.getStr(record);
            if (str != null) {
                this.append(str);
            }
        }

        @Override
        public void computeNext(MapValue mapValue, Record record) {
            CharSequence str = this.arg.getStr(record);
            if (str != null) {
                if (!this.nullValue) {
                    this.appendDelimiter();
                }
                this.append(str);
            }
        }

        @Override
        public void pushValueTypes(ArrayColumnTypes columnTypes) {
            columnTypes.add(10);
        }

        @Override
        public void setNull(MapValue mapValue) {
            this.setNull();
        }

        @Override
        public void close() {
            this.sink.close();
        }

        @Override
        public CharSequence getStr(Record rec) {
            if (this.nullValue) {
                return null;
            }
            return this.sink;
        }

        @Override
        public CharSequence getStrB(Record rec) {
            return this.getStr(rec);
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        private void setNull() {
            this.sink.clear();
            this.nullValue = true;
        }

        private void appendDelimiter() {
            this.sink.put(this.delimiter);
        }

        private void append(CharSequence str) {
            this.sink.put(str);
            this.nullValue = false;
        }
    }
}

