/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.ShortFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import org.jetbrains.annotations.NotNull;

public class SumShortGroupByFunction
extends ShortFunction
implements GroupByFunction,
UnaryFunction {
    private final Function arg;
    private int valueIndex;

    public SumShortGroupByFunction(int position, @NotNull Function arg) {
        super(position);
        this.arg = arg;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record) {
        mapValue.putShort(this.valueIndex, this.arg.getShort(record));
    }

    @Override
    public void computeNext(MapValue mapValue, Record record) {
        mapValue.addShort(this.valueIndex, this.arg.getShort(record));
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(2);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putShort(this.valueIndex, (short)0);
    }

    @Override
    public void setShort(MapValue mapValue, short value) {
        mapValue.putShort(this.valueIndex, value);
    }

    @Override
    public short getShort(Record rec) {
        return rec.getShort(this.valueIndex);
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public boolean isConstant() {
        return false;
    }
}

