/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.ByteFunction;
import io.questdb.std.ObjList;

public class AddByteFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "+(BB)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration1, SqlExecutionContext sqlExecutionContext) {
        return new AddShortVVFunc(position, args.getQuick(0), args.getQuick(1));
    }

    private static class AddShortVVFunc
    extends ByteFunction
    implements BinaryFunction {
        final Function left;
        final Function right;

        public AddShortVVFunc(int position, Function left, Function right) {
            super(position);
            this.left = left;
            this.right = right;
        }

        @Override
        public byte getByte(Record rec) {
            return (byte)(this.left.getByte(rec) + this.right.getByte(rec));
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public Function getRight() {
            return this.right;
        }
    }
}

