/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.std.ObjList;

public class AddLongFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "+(LL)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new AddLongFunc(position, args.getQuick(0), args.getQuick(1));
    }

    private static class AddLongFunc
    extends LongFunction
    implements BinaryFunction {
        final Function left;
        final Function right;

        public AddLongFunc(int position, Function left, Function right) {
            super(position);
            this.left = left;
            this.right = right;
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public Function getRight() {
            return this.right;
        }

        @Override
        public long getLong(Record rec) {
            long l = this.left.getLong(rec);
            long r = this.right.getLong(rec);
            if (l == Long.MIN_VALUE || r == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            return l + r;
        }
    }
}

