/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.ObjList;

public class RoundDoubleZeroScaleFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "round(D)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new RoundDoubleZeroScaleFunction(position, args.getQuick(0));
    }

    static class RoundDoubleZeroScaleFunction
    extends DoubleFunction
    implements UnaryFunction {
        private final Function arg;

        public RoundDoubleZeroScaleFunction(int position, Function arg) {
            super(position);
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public double getDouble(Record rec) {
            double d = this.arg.getDouble(rec);
            return d == d ? (double)Math.round(d) : Double.NaN;
        }
    }
}

