/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.regex;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.bind.IndexedParameterLinkFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.std.Chars;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.StringSink;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractLikeStrFunctionFactory
implements FunctionFactory {
    public static String escapeSpecialChars(CharSequence pattern, CharSequence prev) {
        int len = pattern.length();
        StringSink sink = Misc.getThreadLocalBuilder();
        for (int i = 0; i < len; ++i) {
            char c = pattern.charAt(i);
            if (c == '_') {
                sink.put(".");
                continue;
            }
            if (c == '%') {
                sink.put(".*?");
                continue;
            }
            if ("[](){}.*+?$^|#\\".indexOf(c) != -1) {
                sink.put("\\");
                sink.put(c);
                continue;
            }
            sink.put(c);
        }
        if (Chars.equalsNc((CharSequence)sink, prev)) {
            return null;
        }
        return Chars.toString(sink);
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function value = args.getQuick(0);
        Function pattern = args.getQuick(1);
        if (pattern.isConstant()) {
            CharSequence likeString = pattern.getStr(null);
            if (likeString != null && likeString.length() > 0) {
                String p = AbstractLikeStrFunctionFactory.escapeSpecialChars(likeString, null);
                assert (p != null);
                return new ConstLikeStrFunction(position, value, Pattern.compile(p, 32).matcher(""));
            }
            return BooleanConstant.FALSE;
        }
        if (pattern instanceof IndexedParameterLinkFunction) {
            return new BindLikeStrFunction(position, value, pattern);
        }
        throw SqlException.$(pattern.getPosition(), "use constant or bind variable");
    }

    private static class BindLikeStrFunction
    extends BooleanFunction
    implements UnaryFunction {
        private final Function value;
        private final Function pattern;
        private Matcher matcher;
        private String lastPattern = null;

        public BindLikeStrFunction(int position, Function value, Function pattern) {
            super(position);
            this.value = value;
            this.pattern = pattern;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public boolean getBool(Record rec) {
            if (this.matcher != null) {
                CharSequence cs = this.getArg().getStr(rec);
                return cs != null && this.matcher.reset(cs).matches();
            }
            return false;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            this.value.init(symbolTableSource, executionContext);
            this.pattern.init(symbolTableSource, executionContext);
            CharSequence patternValue = this.pattern.getStr(null);
            if (patternValue != null && patternValue.length() > 0) {
                String p = AbstractLikeStrFunctionFactory.escapeSpecialChars(patternValue, this.lastPattern);
                if (p != null) {
                    this.matcher = Pattern.compile(p, 32).matcher("");
                    this.lastPattern = p;
                }
            } else {
                this.lastPattern = null;
                this.matcher = null;
            }
        }
    }

    private static class ConstLikeStrFunction
    extends BooleanFunction
    implements UnaryFunction {
        private final Function value;
        private final Matcher matcher;

        public ConstLikeStrFunction(int position, Function value, Matcher matcher) {
            super(position);
            this.value = value;
            this.matcher = matcher;
        }

        @Override
        public Function getArg() {
            return this.value;
        }

        @Override
        public boolean getBool(Record rec) {
            CharSequence cs = this.getArg().getStr(rec);
            return cs != null && this.matcher.reset(cs).matches();
        }
    }
}

