/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.ByteFunction;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;

public class RndByteFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "rnd_byte()";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new RndFunction(position);
    }

    private static class RndFunction
    extends ByteFunction
    implements Function {
        private final byte lo = (byte)20;
        private final byte range = (byte)(127 - this.lo + 1);
        private Rnd rnd;

        public RndFunction(int position) {
            super(position);
        }

        @Override
        public byte getByte(Record rec) {
            short s = this.rnd.nextShort();
            if (s < 0) {
                return (byte)(this.lo - s % this.range);
            }
            return (byte)(this.lo + s % this.range);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            this.rnd = executionContext.getRandom();
        }
    }
}

