/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.std.Rnd;

class RndStrFunction
extends StrFunction
implements Function {
    private final int lo;
    private final int range;
    private final int nullRate;
    private Rnd rnd;

    public RndStrFunction(int position, int lo, int hi, int nullRate) {
        super(position);
        this.lo = lo;
        this.range = hi - lo + 1;
        this.nullRate = nullRate;
    }

    @Override
    public CharSequence getStr(Record rec) {
        if (this.rnd.nextInt() % this.nullRate == 1) {
            return null;
        }
        return this.rnd.nextChars(this.lo + this.rnd.nextPositiveInt() % this.range);
    }

    @Override
    public CharSequence getStrB(Record rec) {
        return this.getStr(rec);
    }

    @Override
    public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
        this.rnd = executionContext.getRandom();
    }
}

