/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.cairo.vm.ContiguousVirtualMemory;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;

public class RndStringRndListFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "rnd_str(iiii)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        int hi;
        ContiguousVirtualMemory strMem = new ContiguousVirtualMemory(0x100000L, Integer.MAX_VALUE);
        ContiguousVirtualMemory idxMem = new ContiguousVirtualMemory(0x100000L, Integer.MAX_VALUE);
        int lo = args.getQuick(1).getInt(null);
        if (lo == (hi = args.getQuick(2).getInt(null))) {
            return new FixedFunc(position, strMem, idxMem, lo, args.getQuick(0).getInt(null), args.getQuick(3).getInt(null));
        }
        return new Func(position, strMem, idxMem, args.getQuick(1).getInt(null), args.getQuick(2).getInt(null), args.getQuick(0).getInt(null), args.getQuick(3).getInt(null));
    }

    private static final class FixedFunc
    extends StrFunction
    implements Function {
        private final int count;
        private final ContiguousVirtualMemory strMem;
        private final ContiguousVirtualMemory idxMem;
        private final int strLen;
        private final int nullRate;
        private Rnd rnd;

        public FixedFunc(int position, ContiguousVirtualMemory strMem, ContiguousVirtualMemory idxMem, int strLen, int strCount, int nullRate) {
            super(position);
            this.count = strCount;
            this.strMem = strMem;
            this.idxMem = idxMem;
            this.strLen = strLen;
            this.nullRate = nullRate;
        }

        @Override
        public CharSequence getStr(Record rec) {
            long o = this.idxMem.getLong((long)(this.rnd.nextPositiveInt() % this.count) * 8L);
            return this.strMem.getStr(o);
        }

        @Override
        public CharSequence getStrB(Record rec) {
            long o = this.idxMem.getLong((long)(this.rnd.nextPositiveInt() % this.count) * 8L);
            return this.strMem.getStr2(o);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            this.rnd = executionContext.getRandom();
            this.strMem.jumpTo(0L);
            this.idxMem.jumpTo(0L);
            for (int i = 0; i < this.count; ++i) {
                long o = this.strMem.putStr(this.rnd.nextChars(this.strLen));
                this.idxMem.putLong(o);
            }
        }

        @Override
        public void close() {
            Misc.free(this.strMem);
            Misc.free(this.idxMem);
        }
    }

    private static final class Func
    extends StrFunction
    implements Function {
        private final int count;
        private final ContiguousVirtualMemory strMem;
        private final ContiguousVirtualMemory idxMem;
        private final int strLo;
        private final int strHi;
        private final int nullRate;
        private Rnd rnd;

        public Func(int position, ContiguousVirtualMemory strMem, ContiguousVirtualMemory idxMem, int strLo, int strHi, int strCount, int nullRate) {
            super(position);
            this.count = strCount;
            this.strMem = strMem;
            this.idxMem = idxMem;
            this.strLo = strLo;
            this.strHi = strHi;
            this.nullRate = nullRate;
        }

        @Override
        public CharSequence getStr(Record rec) {
            long o = this.idxMem.getLong((long)(this.rnd.nextPositiveInt() % this.count) * 8L);
            return this.strMem.getStr(o);
        }

        @Override
        public CharSequence getStrB(Record rec) {
            long o = this.idxMem.getLong((long)(this.rnd.nextPositiveInt() % this.count) * 8L);
            return this.strMem.getStr2(o);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            this.rnd = executionContext.getRandom();
            this.strMem.jumpTo(0L);
            this.idxMem.jumpTo(0L);
            for (int i = 0; i < this.count; ++i) {
                long o = this.strMem.putStr(this.rnd.nextChars(this.strLo + this.rnd.nextPositiveInt() % (this.strHi - this.strLo)));
                this.idxMem.putLong(o);
            }
        }

        @Override
        public void close() {
            Misc.free(this.strMem);
            Misc.free(this.idxMem);
        }
    }
}

