/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.functions.rnd.RndStringListFunctionFactory;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;

public class RndSymbolListFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "rnd_symbol(V)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        ObjList<String> symbols = new ObjList<String>(args.size());
        RndStringListFunctionFactory.copyConstants(args, symbols);
        return new Func(position, symbols);
    }

    private static final class Func
    extends SymbolFunction
    implements Function {
        private final ObjList<String> symbols;
        private final int count;
        private Rnd rnd;

        public Func(int position, ObjList<String> symbols) {
            super(position);
            this.symbols = symbols;
            this.count = symbols.size();
        }

        @Override
        public int getInt(Record rec) {
            return this.next();
        }

        @Override
        public CharSequence getSymbol(Record rec) {
            return this.symbols.getQuick(this.next());
        }

        @Override
        public CharSequence getSymbolB(Record rec) {
            return this.getSymbol(rec);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            this.rnd = executionContext.getRandom();
        }

        @Override
        public boolean isSymbolTableStatic() {
            return false;
        }

        @Override
        public CharSequence valueOf(int symbolKey) {
            return this.symbols.getQuick(TableUtils.toIndexKey(symbolKey));
        }

        @Override
        public CharSequence valueBOf(int key) {
            return this.valueOf(key);
        }

        private int next() {
            return Math.abs(this.rnd.nextPositiveInt() % this.count);
        }
    }
}

