/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.str;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.MultiArgFunction;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;

public class ConcatFunctionFactory
implements FunctionFactory {
    private static final ObjList<TypeAdapter> adapterReferences = new ObjList();

    private static void sinkLong(CharSink sink, Function function, Record record) {
        sink.put(function.getLong(record));
    }

    private static void sinkByte(CharSink sink, Function function, Record record) {
        sink.put(function.getByte(record));
    }

    private static void sinkShort(CharSink sink, Function function, Record record) {
        sink.put(function.getShort(record));
    }

    private static void sinkChar(CharSink sink, Function function, Record record) {
        sink.put(function.getChar(record));
    }

    private static void sinkInt(CharSink sink, Function function, Record record) {
        sink.put(function.getInt(record));
    }

    private static void sinkFloat(CharSink sink, Function function, Record record) {
        sink.put(function.getFloat(record), 3);
    }

    private static void sinkDouble(CharSink sink, Function function, Record record) {
        sink.put(function.getDouble(record));
    }

    private static void sinkSymbol(CharSink sink, Function function, Record record) {
        sink.put(function.getSymbol(record));
    }

    private static void sinkBool(CharSink sink, Function function, Record record) {
        sink.put(function.getBool(record));
    }

    private static void sinkDate(CharSink sink, Function function, Record record) {
        sink.put(function.getDate(record));
    }

    private static void sinkTimestamp(CharSink sink, Function function, Record record) {
        sink.put(function.getTimestamp(record));
    }

    private static void sinkLong256(CharSink sink, Function function, Record record) {
        function.getLong256(record, sink);
    }

    private static void sinkBin(CharSink sink, Function function, Record record) {
        sink.put('[');
        sink.put(']');
    }

    private static void sinkStr(CharSink sink, Function function, Record record) {
        function.getStr(record, sink);
    }

    @Override
    public String getSignature() {
        return "concat(V)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        ObjList<Function> functions = new ObjList<Function>(args.size());
        functions.addAll(args);
        return new ConcatFunction(position, functions);
    }

    static {
        adapterReferences.extendAndSet(12, ConcatFunctionFactory::sinkLong256);
        adapterReferences.extendAndSet(0, ConcatFunctionFactory::sinkBool);
        adapterReferences.extendAndSet(1, ConcatFunctionFactory::sinkByte);
        adapterReferences.extendAndSet(2, ConcatFunctionFactory::sinkShort);
        adapterReferences.extendAndSet(3, ConcatFunctionFactory::sinkChar);
        adapterReferences.extendAndSet(4, ConcatFunctionFactory::sinkInt);
        adapterReferences.extendAndSet(5, ConcatFunctionFactory::sinkLong);
        adapterReferences.extendAndSet(8, ConcatFunctionFactory::sinkFloat);
        adapterReferences.extendAndSet(9, ConcatFunctionFactory::sinkDouble);
        adapterReferences.extendAndSet(10, ConcatFunctionFactory::sinkStr);
        adapterReferences.extendAndSet(11, ConcatFunctionFactory::sinkSymbol);
        adapterReferences.extendAndSet(13, ConcatFunctionFactory::sinkBin);
        adapterReferences.extendAndSet(6, ConcatFunctionFactory::sinkDate);
        adapterReferences.extendAndSet(7, ConcatFunctionFactory::sinkTimestamp);
    }

    private static class ConcatFunction
    extends StrFunction
    implements MultiArgFunction {
        private final ObjList<Function> functions;
        private final ObjList<TypeAdapter> adaptors;
        private final StringSink sinkA = new StringSink();
        private final StringSink sinkB = new StringSink();
        private final int functionCount;

        public ConcatFunction(int position, ObjList<Function> functions) {
            super(position);
            this.functions = functions;
            this.functionCount = functions.size();
            this.adaptors = new ObjList(this.functionCount);
            for (int i = 0; i < this.functionCount; ++i) {
                this.adaptors.add((TypeAdapter)adapterReferences.getQuick(functions.getQuick(i).getType()));
            }
        }

        @Override
        public CharSequence getStr(Record rec) {
            this.sinkA.clear();
            this.getStr(rec, this.sinkA);
            return this.sinkA;
        }

        @Override
        public CharSequence getStrB(Record rec) {
            this.sinkB.clear();
            this.getStr(rec, this.sinkB);
            return this.sinkB;
        }

        @Override
        public void getStr(Record rec, CharSink sink) {
            for (int i = 0; i < this.functionCount; ++i) {
                this.adaptors.getQuick(i).sink(sink, this.functions.getQuick(i), rec);
            }
        }

        @Override
        public ObjList<Function> getArgs() {
            return this.functions;
        }
    }

    @FunctionalInterface
    private static interface TypeAdapter {
        public void sink(CharSink var1, Function var2, Record var3);
    }
}

