/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.str;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;
import org.jetbrains.annotations.NotNull;

public class ReplaceStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "replace(SSS)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        int len;
        Function term = args.getQuick(1);
        if (term.isConstant() && term.getStrLen(null) < 1) {
            return args.getQuick(0);
        }
        Function value = args.getQuick(0);
        if (value.isConstant() && (len = value.getStrLen(null)) < 1) {
            return value;
        }
        return new Func(position, value, term, args.getQuick(2));
    }

    private static class Func
    extends StrFunction {
        private final StringSink sink = new StringSink();
        private final StringSink sinkB = new StringSink();
        private final Function value;
        private final Function oldSubStr;
        private final Function newSubStr;

        public Func(int position, Function value, Function oldSubStr, Function newSubStr) {
            super(position);
            this.value = value;
            this.oldSubStr = oldSubStr;
            this.newSubStr = newSubStr;
        }

        @Override
        public CharSequence getStr(Record rec) {
            CharSequence value = this.value.getStr(rec);
            if (value != null) {
                this.sink.clear();
                this.replace(value, this.oldSubStr.getStr(rec), this.newSubStr.getStr(rec), this.sink);
                return this.sink;
            }
            return null;
        }

        @Override
        public CharSequence getStrB(Record rec) {
            CharSequence value = this.value.getStrB(rec);
            if (value != null) {
                this.sinkB.clear();
                this.replace(value, this.oldSubStr.getStrB(rec), this.newSubStr.getStrB(rec), this.sinkB);
                return this.sinkB;
            }
            return null;
        }

        @Override
        public void getStr(Record rec, CharSink sink) {
            CharSequence value = this.value.getStrB(rec);
            if (value != null) {
                this.replace(value, this.oldSubStr.getStr(rec), this.newSubStr.getStr(rec), sink);
            }
        }

        private void replace(@NotNull CharSequence value, CharSequence term, CharSequence withWhat, CharSink sink) {
            int termLen;
            int valueLen = value.length();
            if (valueLen < 1) {
                return;
            }
            if (term == null || (termLen = term.length()) < 1) {
                sink.put(value);
                return;
            }
            block0: for (int i = 0; i < valueLen; ++i) {
                char c = value.charAt(i);
                if (c == term.charAt(0)) {
                    if (valueLen - i < termLen) {
                        sink.put(value, i, valueLen);
                        break;
                    }
                    for (int k = 1; k < termLen && k + i < valueLen; ++k) {
                        if (value.charAt(i + k) == term.charAt(k)) continue;
                        sink.put(c);
                        continue block0;
                    }
                    sink.put(withWhat);
                    sink.put(value, i + termLen, valueLen);
                    break;
                }
                sink.put(c);
            }
        }

        @Override
        public boolean isConstant() {
            return this.value.isConstant() && this.oldSubStr.isConstant() && this.newSubStr.isConstant();
        }
    }
}

