/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.str;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.Chars;
import io.questdb.std.ObjList;
import io.questdb.std.str.StringSink;

public class ToLowercaseFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "to_lowercase(S)";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new ToLowercaseFunc(position, args.get(0));
    }

    private static class ToLowercaseFunc
    extends StrFunction
    implements UnaryFunction {
        private final Function arg;
        private final StringSink sinkA = new StringSink();
        private final StringSink sinkB = new StringSink();

        public ToLowercaseFunc(int position, Function arg) {
            super(position);
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public CharSequence getStr(Record rec) {
            CharSequence str = this.getArg().getStr(rec);
            if (str == null) {
                return null;
            }
            this.sinkA.clear();
            Chars.toLowerCase(str, this.sinkA);
            return this.sinkA;
        }

        @Override
        public CharSequence getStrB(Record rec) {
            CharSequence str = this.getArg().getStr(rec);
            if (str == null) {
                return null;
            }
            this.sinkB.clear();
            Chars.toLowerCase(str, this.sinkB);
            return this.sinkB;
        }

        @Override
        public int getStrLen(Record rec) {
            return this.arg.getStrLen(rec);
        }
    }
}

