/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.test;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.std.ObjList;
import java.util.concurrent.atomic.AtomicInteger;

public class TestLatchedCounterFunctionFactory
implements FunctionFactory {
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private static volatile Callback CALLBACK;

    public static void reset(Callback callback) {
        CALLBACK = callback;
        COUNTER.set(0);
    }

    public static int getCount() {
        return COUNTER.get();
    }

    @Override
    public String getSignature() {
        return "test_latched_counter()";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new TestLatchFunction(position);
    }

    static /* synthetic */ Callback access$000() {
        return CALLBACK;
    }

    public static interface Callback {
        default public boolean onGet(Record rec, int count) {
            return true;
        }

        default public void onClose() {
        }
    }

    private static class TestLatchFunction
    extends BooleanFunction {
        private final Callback callback = TestLatchedCounterFunctionFactory.access$000();

        public TestLatchFunction(int position) {
            super(position);
        }

        @Override
        public boolean getBool(Record rec) {
            int count = COUNTER.incrementAndGet();
            if (null == this.callback) {
                return true;
            }
            return this.callback.onGet(rec, count);
        }

        @Override
        public void close() {
            if (null != this.callback) {
                this.callback.onClose();
            }
        }
    }
}

