/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.test;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.std.ObjList;
import java.util.concurrent.atomic.AtomicInteger;

public class TestMatchFunctionFactory
implements FunctionFactory {
    private static final AtomicInteger openCounter = new AtomicInteger();
    private static final AtomicInteger topCounter = new AtomicInteger();
    private static final AtomicInteger closeCount = new AtomicInteger();

    public static boolean assertAPI() {
        return openCounter.get() > 0 && topCounter.get() > 0 && closeCount.get() == 1;
    }

    public static boolean isClosed() {
        return closeCount.get() == 1;
    }

    public static void clear() {
        openCounter.set(0);
        topCounter.set(0);
        closeCount.set(0);
    }

    @Override
    public String getSignature() {
        return "test_match()";
    }

    @Override
    public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new TestMatchFunction(position);
    }

    private static class TestMatchFunction
    extends BooleanFunction {
        public TestMatchFunction(int position) {
            super(position);
        }

        @Override
        public void close() {
            closeCount.incrementAndGet();
        }

        @Override
        public boolean getBool(Record rec) {
            return true;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext sqlExecutionContext) {
            openCounter.incrementAndGet();
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        @Override
        public void toTop() {
            assert (openCounter.get() > 0);
            topCounter.incrementAndGet();
        }
    }
}

