/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.sql.DelegatingRecordCursor;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlExecutionInterruptor;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.groupby.GroupByUtils;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.ObjList;

public abstract class AbstractNoRecordSampleByCursor
implements DelegatingRecordCursor,
NoRandomAccessRecordCursor {
    protected final TimestampSampler timestampSampler;
    protected final int timestampIndex;
    protected final ObjList<GroupByFunction> groupByFunctions;
    private final ObjList<Function> recordFunctions;
    protected Record baseRecord;
    protected long lastTimestamp;
    protected long nextTimestamp;
    protected RecordCursor base;
    protected SqlExecutionInterruptor interruptor;
    protected long baselineOffset;

    public AbstractNoRecordSampleByCursor(ObjList<Function> recordFunctions, int timestampIndex, TimestampSampler timestampSampler, ObjList<GroupByFunction> groupByFunctions) {
        this.timestampIndex = timestampIndex;
        this.timestampSampler = timestampSampler;
        this.recordFunctions = recordFunctions;
        this.groupByFunctions = groupByFunctions;
    }

    @Override
    public void close() {
        this.base.close();
        this.interruptor = null;
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return (SymbolTable)((Object)this.recordFunctions.getQuick(columnIndex));
    }

    @Override
    public void toTop() {
        GroupByUtils.toTop(this.recordFunctions);
        this.base.toTop();
    }

    @Override
    public long size() {
        return -1L;
    }

    protected long getBaseRecordTimestamp() {
        return this.timestampSampler.round(this.baseRecord.getTimestamp(this.timestampIndex) - this.baselineOffset);
    }

    @Override
    public void of(RecordCursor base, SqlExecutionContext executionContext) {
        this.base = base;
        this.baseRecord = base.getRecord();
        long timestamp = this.baseRecord.getTimestamp(this.timestampIndex);
        this.nextTimestamp = this.timestampSampler.round(timestamp);
        this.baselineOffset = timestamp - this.nextTimestamp;
        this.lastTimestamp = this.nextTimestamp;
        this.interruptor = executionContext.getSqlExecutionInterruptor();
    }

    protected class TimestampFunc
    extends TimestampFunction
    implements Function {
        public TimestampFunc(int position) {
            super(position);
        }

        @Override
        public long getTimestamp(Record rec) {
            return AbstractNoRecordSampleByCursor.this.lastTimestamp + AbstractNoRecordSampleByCursor.this.baselineOffset;
        }
    }
}

