/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.EntityColumnFilter;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.RecordSinkFactory;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlExecutionInterruptor;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.Misc;
import org.jetbrains.annotations.NotNull;

public class DistinctRecordCursorFactory
implements RecordCursorFactory {
    protected final RecordCursorFactory base;
    private final Map dataMap;
    private final DistinctRecordCursor cursor;
    private final RecordSink mapSink;
    private final RecordMetadata metadata;

    public DistinctRecordCursorFactory(CairoConfiguration configuration, RecordCursorFactory base, @NotNull EntityColumnFilter columnFilter, @NotNull BytecodeAssembler asm) {
        RecordMetadata metadata = base.getMetadata();
        columnFilter.of(metadata.getColumnCount());
        this.mapSink = RecordSinkFactory.getInstance(asm, metadata, columnFilter, false);
        this.dataMap = MapFactory.createMap(configuration, metadata);
        this.base = base;
        this.metadata = metadata;
        this.cursor = new DistinctRecordCursor();
    }

    @Override
    public void close() {
        this.dataMap.close();
        this.base.close();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        this.dataMap.clear();
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        try {
            this.cursor.of(baseCursor, this.dataMap, this.mapSink, executionContext.getSqlExecutionInterruptor());
            return this.cursor;
        }
        catch (Throwable e) {
            baseCursor.close();
            throw e;
        }
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return this.base.recordCursorSupportsRandomAccess();
    }

    private static class DistinctRecordCursor
    implements RecordCursor {
        private RecordCursor baseCursor;
        private Map dataMap;
        private RecordSink recordSink;
        private Record record;
        private SqlExecutionInterruptor interruptor;

        @Override
        public void close() {
            Misc.free(this.baseCursor);
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            return this.baseCursor.getSymbolTable(columnIndex);
        }

        @Override
        public boolean hasNext() {
            while (this.baseCursor.hasNext()) {
                this.interruptor.checkInterrupted();
                MapKey key = this.dataMap.withKey();
                this.recordSink.copy(this.record, key);
                if (!key.create()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Record getRecordB() {
            return this.baseCursor.getRecordB();
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            this.baseCursor.recordAt(record, atRowId);
        }

        @Override
        public void toTop() {
            this.baseCursor.toTop();
            this.dataMap.clear();
        }

        public void of(RecordCursor baseCursor, Map dataMap, RecordSink recordSink, SqlExecutionInterruptor interruptor) {
            this.baseCursor = baseCursor;
            this.dataMap = dataMap;
            this.recordSink = recordSink;
            this.record = baseCursor.getRecord();
            this.interruptor = interruptor;
        }

        @Override
        public long size() {
            return -1L;
        }
    }
}

