/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.Misc;

public class DistinctSymbolRecordCursorFactory
implements RecordCursorFactory {
    private final DistinctSymbolRecordCursor cursor;
    private final CairoEngine engine;
    private final GenericRecordMetadata metadata;
    private final String tableName;
    private final int columnIndex;
    private final long tableVersion;

    public DistinctSymbolRecordCursorFactory(CairoEngine engine, GenericRecordMetadata metadata, String tableName, int columnIndex, long tableVersion) {
        this.engine = engine;
        this.metadata = metadata;
        this.tableName = tableName;
        this.columnIndex = columnIndex;
        this.tableVersion = tableVersion;
        this.cursor = new DistinctSymbolRecordCursor();
    }

    @Override
    public void close() {
        this.cursor.close();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        TableReader reader = this.engine.getReader(executionContext.getCairoSecurityContext(), this.tableName, this.tableVersion);
        this.cursor.of(reader, this.columnIndex);
        return this.cursor;
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    private static class DistinctSymbolRecordCursor
    implements RecordCursor {
        private final DistinctSymbolRecord recordA = new DistinctSymbolRecord();
        private DistinctSymbolRecord recordB = null;
        private TableReader reader;
        private int numberOfSymbols;
        private SymbolMapReader symbolMapReader;

        private DistinctSymbolRecordCursor() {
        }

        @Override
        public void close() {
            this.reader = Misc.free(this.reader);
        }

        @Override
        public Record getRecord() {
            return this.recordA;
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            return this.symbolMapReader;
        }

        @Override
        public boolean hasNext() {
            if (this.recordA.getAndIncrementRecordIndex() < (long)this.numberOfSymbols) {
                return true;
            }
            this.recordA.decrementRecordIndex();
            return false;
        }

        @Override
        public Record getRecordB() {
            if (this.recordB == null) {
                this.recordB = new DistinctSymbolRecord();
            }
            this.recordB.reset();
            return this.recordB;
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            ((DistinctSymbolRecord)record).recordIndex = (int)atRowId;
        }

        @Override
        public void toTop() {
            this.recordA.reset();
        }

        public void of(TableReader reader, int columnIndex) {
            this.reader = reader;
            this.symbolMapReader = reader.getSymbolMapReader(columnIndex);
            this.numberOfSymbols = this.symbolMapReader.size() + (this.symbolMapReader.containsNullValue() ? 1 : 0);
            this.recordA.reset();
        }

        @Override
        public long size() {
            return this.numberOfSymbols;
        }

        public class DistinctSymbolRecord
        implements Record {
            private int recordIndex = -1;

            public void decrementRecordIndex() {
                --this.recordIndex;
            }

            @Override
            public CharSequence getSym(int col) {
                return DistinctSymbolRecordCursor.this.symbolMapReader.valueOf(this.recordIndex);
            }

            @Override
            public CharSequence getSymB(int col) {
                return DistinctSymbolRecordCursor.this.symbolMapReader.valueBOf(this.recordIndex);
            }

            @Override
            public int getInt(int col) {
                return this.recordIndex;
            }

            @Override
            public CharSequence getStr(int col) {
                return this.getSym(col);
            }

            @Override
            public CharSequence getStrB(int col) {
                return this.getSym(col);
            }

            @Override
            public int getStrLen(int col) {
                return this.getSym(col).length();
            }

            @Override
            public long getRowId() {
                return this.recordIndex;
            }

            public void reset() {
                this.recordIndex = -1;
            }

            public long getAndIncrementRecordIndex() {
                return ++this.recordIndex;
            }
        }
    }
}

