/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.RecordSinkFactory;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.groupby.GroupByUtils;
import io.questdb.griffin.engine.groupby.VirtualFunctionSkewedSymbolRecordCursor;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class GroupByRecordCursorFactory
implements RecordCursorFactory {
    protected final RecordCursorFactory base;
    private final Map dataMap;
    private final VirtualFunctionSkewedSymbolRecordCursor cursor;
    private final ObjList<Function> recordFunctions;
    private final ObjList<GroupByFunction> groupByFunctions;
    private final RecordSink mapSink;
    private final RecordMetadata metadata;

    public GroupByRecordCursorFactory(CairoConfiguration configuration, RecordCursorFactory base, @NotNull ListColumnFilter listColumnFilter, @NotNull BytecodeAssembler asm, @NotNull ArrayColumnTypes keyTypes, @NotNull ArrayColumnTypes valueTypes, RecordMetadata groupByMetadata, ObjList<GroupByFunction> groupByFunctions, ObjList<Function> recordFunctions) {
        try {
            this.dataMap = MapFactory.createMap(configuration, keyTypes, valueTypes);
            this.mapSink = RecordSinkFactory.getInstance(asm, base.getMetadata(), listColumnFilter, false);
            this.base = base;
            this.metadata = groupByMetadata;
            this.groupByFunctions = groupByFunctions;
            this.recordFunctions = recordFunctions;
            this.cursor = new VirtualFunctionSkewedSymbolRecordCursor(recordFunctions);
        }
        catch (Throwable e) {
            Misc.freeObjList(recordFunctions);
            throw e;
        }
    }

    @Override
    public void close() {
        Misc.freeObjList(this.recordFunctions);
        Misc.free(this.dataMap);
        Misc.free(this.base);
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        this.dataMap.clear();
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        try {
            Record baseRecord = baseCursor.getRecord();
            int n = this.groupByFunctions.size();
            while (baseCursor.hasNext()) {
                executionContext.getSqlExecutionInterruptor().checkInterrupted();
                MapKey key = this.dataMap.withKey();
                this.mapSink.copy(baseRecord, key);
                MapValue value = key.createValue();
                GroupByUtils.updateFunctions(this.groupByFunctions, n, value, baseRecord);
            }
            this.cursor.of(baseCursor, this.dataMap.getCursor());
            Function.init(this.recordFunctions, baseCursor, executionContext);
            return this.cursor;
        }
        catch (Throwable e) {
            baseCursor.close();
            throw e;
        }
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }
}

