/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.BaseRecordMetadata;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.ScalarFunction;
import io.questdb.griffin.FunctionParser;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.functions.columns.BinColumn;
import io.questdb.griffin.engine.functions.columns.BooleanColumn;
import io.questdb.griffin.engine.functions.columns.ByteColumn;
import io.questdb.griffin.engine.functions.columns.CharColumn;
import io.questdb.griffin.engine.functions.columns.DateColumn;
import io.questdb.griffin.engine.functions.columns.DoubleColumn;
import io.questdb.griffin.engine.functions.columns.FloatColumn;
import io.questdb.griffin.engine.functions.columns.IntColumn;
import io.questdb.griffin.engine.functions.columns.Long256Column;
import io.questdb.griffin.engine.functions.columns.LongColumn;
import io.questdb.griffin.engine.functions.columns.ShortColumn;
import io.questdb.griffin.engine.functions.columns.StrColumn;
import io.questdb.griffin.engine.functions.columns.TimestampColumn;
import io.questdb.griffin.engine.groupby.MapSymbolColumn;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.QueryColumn;
import io.questdb.griffin.model.QueryModel;
import io.questdb.std.Chars;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class GroupByUtils {
    public static void prepareGroupByFunctions(QueryModel model, RecordMetadata metadata, FunctionParser functionParser, SqlExecutionContext executionContext, ObjList<GroupByFunction> groupByFunctions, ArrayColumnTypes valueTypes) throws SqlException {
        ObjList<QueryColumn> columns = model.getColumns();
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            QueryColumn column = columns.getQuick(i);
            ExpressionNode node = column.getAst();
            if (node.type == 4) continue;
            Function function = functionParser.parseFunction(column.getAst(), metadata, executionContext);
            assert (function instanceof GroupByFunction);
            GroupByFunction func = (GroupByFunction)function;
            func.pushValueTypes(valueTypes);
            groupByFunctions.add(func);
        }
    }

    public static void prepareGroupByRecordFunctions(@NotNull QueryModel model, RecordMetadata metadata, @NotNull ListColumnFilter listColumnFilter, ObjList<GroupByFunction> groupByFunctions, ObjList<Function> recordFunctions, GenericRecordMetadata groupByMetadata, ArrayColumnTypes keyTypes, int keyColumnIndex, boolean timestampUnimportant, int timestampIndex) throws SqlException {
        ObjList<QueryColumn> columns = model.getColumns();
        int valueColumnIndex = 0;
        int inferredKeyColumnCount = 0;
        int lastIndex = -1;
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            int type;
            QueryColumn column = columns.getQuick(i);
            ExpressionNode node = column.getAst();
            if (node.type == 4) {
                int index = metadata.getColumnIndexQuiet(node.token);
                if (index == -1) {
                    throw SqlException.invalidColumn(node.position, node.token);
                }
                type = metadata.getColumnType(index);
                if (index != timestampIndex || timestampUnimportant) {
                    ScalarFunction fun;
                    if (lastIndex != index) {
                        listColumnFilter.add(index + 1);
                        keyTypes.add(type);
                        ++keyColumnIndex;
                        lastIndex = index;
                    }
                    switch (type) {
                        case 0: {
                            fun = new BooleanColumn(node.position, keyColumnIndex - 1);
                            break;
                        }
                        case 1: {
                            fun = new ByteColumn(node.position, keyColumnIndex - 1);
                            break;
                        }
                        case 2: {
                            fun = new ShortColumn(node.position, keyColumnIndex - 1);
                            break;
                        }
                        case 3: {
                            fun = new CharColumn(node.position, keyColumnIndex - 1);
                            break;
                        }
                        case 4: {
                            fun = new IntColumn(node.position, keyColumnIndex - 1);
                            break;
                        }
                        case 5: {
                            fun = new LongColumn(node.position, keyColumnIndex - 1);
                            break;
                        }
                        case 8: {
                            fun = new FloatColumn(node.position, keyColumnIndex - 1);
                            break;
                        }
                        case 9: {
                            fun = new DoubleColumn(node.position, keyColumnIndex - 1);
                            break;
                        }
                        case 10: {
                            fun = new StrColumn(node.position, keyColumnIndex - 1);
                            break;
                        }
                        case 11: {
                            fun = new MapSymbolColumn(node.position, keyColumnIndex - 1, index, metadata.isSymbolTableStatic(index));
                            break;
                        }
                        case 6: {
                            fun = new DateColumn(node.position, keyColumnIndex - 1);
                            break;
                        }
                        case 7: {
                            fun = new TimestampColumn(node.position, keyColumnIndex - 1);
                            break;
                        }
                        case 12: {
                            fun = new Long256Column(node.position, keyColumnIndex - 1);
                            break;
                        }
                        default: {
                            fun = new BinColumn(node.position, keyColumnIndex - 1);
                        }
                    }
                    recordFunctions.add(fun);
                } else {
                    recordFunctions.add(null);
                    if (groupByMetadata.getTimestampIndex() == -1) {
                        groupByMetadata.setTimestampIndex(i);
                    }
                    assert (type == 7);
                }
                if (column.getAlias() == null) {
                    groupByMetadata.add(BaseRecordMetadata.copyOf(metadata, index));
                } else {
                    groupByMetadata.add(new TableColumnMetadata(Chars.toString(column.getAlias()), type, metadata.isColumnIndexed(index), metadata.getIndexValueBlockCapacity(index), metadata.isSymbolTableStatic(index), metadata.getMetadata(index)));
                }
                ++inferredKeyColumnCount;
                continue;
            }
            GroupByFunction groupByFunction = groupByFunctions.getQuick(valueColumnIndex++);
            recordFunctions.add(groupByFunction);
            type = groupByFunction.getType();
            groupByMetadata.add(new TableColumnMetadata(Chars.toString(column.getName()), type, false, 0, groupByFunction instanceof SymbolFunction && ((SymbolFunction)((Object)groupByFunction)).isSymbolTableStatic(), groupByFunction.getMetadata()));
        }
        GroupByUtils.validateGroupByColumns(model, inferredKeyColumnCount);
    }

    public static void toTop(ObjList<? extends Function> args) {
        int n = args.size();
        for (int i = 0; i < n; ++i) {
            args.getQuick(i).toTop();
        }
    }

    public static void updateExisting(ObjList<GroupByFunction> groupByFunctions, int n, MapValue value, Record record) {
        for (int i = 0; i < n; ++i) {
            groupByFunctions.getQuick(i).computeNext(value, record);
        }
    }

    public static void updateNew(ObjList<GroupByFunction> groupByFunctions, int n, MapValue value, Record record) {
        for (int i = 0; i < n; ++i) {
            groupByFunctions.getQuick(i).computeFirst(value, record);
        }
    }

    public static void validateGroupByColumns(@NotNull QueryModel model, int inferredKeyColumnCount) throws SqlException {
        QueryModel chooseModel;
        ObjList<ExpressionNode> groupByColumns = model.getGroupBy();
        int explicitKeyColumnCount = groupByColumns.size();
        if (explicitKeyColumnCount == 0) {
            return;
        }
        QueryModel nested = model.getNestedModel();
        for (chooseModel = model; chooseModel != null && chooseModel.getSelectModelType() != 1 && chooseModel.getSelectModelType() != 0; chooseModel = chooseModel.getNestedModel()) {
        }
        block6: for (int i = 0; i < explicitKeyColumnCount; ++i) {
            ExpressionNode key = groupByColumns.getQuick(i);
            switch (key.type) {
                case 4: {
                    int dotIndex = Chars.indexOf(key.token, '.');
                    if (dotIndex > -1) {
                        int aliasIndex = model.getAliasIndex(key.token, 0, dotIndex);
                        if (aliasIndex > -1) {
                            int refColumn = model.getAliasToColumnMap().keyIndex(key.token);
                            if (refColumn > -1) {
                                refColumn = model.getAliasToColumnMap().keyIndex(key.token, dotIndex + 1, key.token.length());
                            }
                            if (refColumn <= -1) continue block6;
                            throw SqlException.$(key.position, "group by column does not match any key column is select statement");
                        }
                        if (chooseModel != null && chooseModel.getColumnNameToAliasMap().keyIndex(key.token) < 0) continue block6;
                        throw SqlException.$(key.position, "invalid column reference");
                    }
                    int refColumn = model.getAliasToColumnMap().keyIndex(key.token);
                    if (refColumn > -1) {
                        throw SqlException.$(key.position, "group by column does not match any key column is select statement");
                    }
                    QueryColumn qc = model.getAliasToColumnMap().valueAt(refColumn);
                    if (qc.getAst().type == 4 || qc.getAst().type == 2) continue block6;
                    throw SqlException.$(key.position, "group by column references aggregate expression");
                }
                case 6: {
                    throw SqlException.$(key.position, "bind variable is not allowed here");
                }
                case 1: 
                case 2: 
                case 8: {
                    ObjList<QueryColumn> availableColumns = nested.getTopDownColumns();
                    boolean invalid = true;
                    int n = availableColumns.size();
                    for (int j = 0; j < n; ++j) {
                        QueryColumn qc = availableColumns.getQuick(j);
                        if (qc.getAst().type != key.type || !ExpressionNode.compareNodesGroupBy(key, qc.getAst(), chooseModel)) continue;
                        invalid = false;
                        break;
                    }
                    if (!invalid) continue block6;
                    throw SqlException.$(key.position, "group by expression does not match anything select in statement");
                }
                default: {
                    throw SqlException.$(key.position, "unsupported type of expression");
                }
            }
        }
        if (explicitKeyColumnCount < inferredKeyColumnCount) {
            throw SqlException.$(model.getModelPosition(), "not enough columns in group by");
        }
    }

    static void updateFunctions(ObjList<GroupByFunction> groupByFunctions, int n, MapValue value, Record record) {
        if (value.isNew()) {
            GroupByUtils.updateNew(groupByFunctions, n, value, record);
        } else {
            GroupByUtils.updateExisting(groupByFunctions, n, value, record);
        }
    }
}

