/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.datetime.microtime.Timestamps;

class MonthTimestampSampler
implements TimestampSampler {
    private final int bucket;

    MonthTimestampSampler(int bucket) {
        this.bucket = bucket;
    }

    @Override
    public long nextTimestamp(long timestamp) {
        return Timestamps.addMonths(timestamp, this.bucket);
    }

    @Override
    public long previousTimestamp(long timestamp) {
        return Timestamps.addMonths(timestamp, -this.bucket);
    }

    @Override
    public long round(long value) {
        int y = Timestamps.getYear(value);
        boolean l = Timestamps.isLeapYear(y);
        int m = Timestamps.getMonthOfYear(value, y, l);
        int n = (m - 1) / this.bucket * this.bucket + 1;
        return Timestamps.yearMicros(y, l) + Timestamps.monthOfYearMicros(n, l);
    }
}

