/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.sql.Function;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.groupby.AbstractVirtualRecordSampleByCursor;
import io.questdb.griffin.engine.groupby.GroupByUtils;
import io.questdb.griffin.engine.groupby.SimpleMapValue;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.ObjList;

class SampleByFillNoneNotKeyedRecordCursor
extends AbstractVirtualRecordSampleByCursor {
    private final SimpleMapValue simpleMapValue;

    public SampleByFillNoneNotKeyedRecordCursor(SimpleMapValue simpleMapValue, ObjList<GroupByFunction> groupByFunctions, ObjList<Function> recordFunctions, int timestampIndex, TimestampSampler timestampSampler) {
        super(recordFunctions, timestampIndex, timestampSampler, groupByFunctions);
        this.simpleMapValue = simpleMapValue;
        this.record.of(simpleMapValue);
    }

    @Override
    public boolean hasNext() {
        if (this.baseRecord == null) {
            return false;
        }
        this.lastTimestamp = this.nextTimestamp;
        int n = this.groupByFunctions.size();
        GroupByUtils.updateNew(this.groupByFunctions, n, this.simpleMapValue, this.baseRecord);
        while (this.base.hasNext()) {
            long timestamp = this.getBaseRecordTimestamp();
            if (this.lastTimestamp != timestamp) {
                this.nextTimestamp = timestamp;
                GroupByUtils.toTop(this.groupByFunctions);
                return true;
            }
            GroupByUtils.updateExisting(this.groupByFunctions, n, this.simpleMapValue, this.baseRecord);
            this.interruptor.checkInterrupted();
        }
        this.baseRecord = null;
        return true;
    }

    @Override
    public void toTop() {
        super.toTop();
        if (this.base.hasNext()) {
            this.baseRecord = this.base.getRecord();
            this.lastTimestamp = this.nextTimestamp = this.timestampSampler.round(this.baseRecord.getTimestamp(this.timestampIndex));
        }
    }
}

