/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.EmptyTableNoSizeRecordCursor;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.groupby.SampleByFillNoneNotKeyedRecordCursor;
import io.questdb.griffin.engine.groupby.SimpleMapValue;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class SampleByFillNoneNotKeyedRecordCursorFactory
implements RecordCursorFactory {
    protected final RecordCursorFactory base;
    private final SampleByFillNoneNotKeyedRecordCursor cursor;
    private final RecordMetadata metadata;
    private final ObjList<Function> recordFunctions;

    public SampleByFillNoneNotKeyedRecordCursorFactory(RecordCursorFactory base, @NotNull TimestampSampler timestampSampler, RecordMetadata groupByMetadata, ObjList<GroupByFunction> groupByFunctions, ObjList<Function> recordFunctions, int valueCount, int timestampIndex) {
        SimpleMapValue simpleMapValue = new SimpleMapValue(valueCount);
        this.recordFunctions = recordFunctions;
        try {
            this.base = base;
            this.metadata = groupByMetadata;
            this.cursor = new SampleByFillNoneNotKeyedRecordCursor(simpleMapValue, groupByFunctions, recordFunctions, timestampIndex, timestampSampler);
        }
        catch (Throwable e) {
            Misc.freeObjList(recordFunctions);
            throw e;
        }
    }

    @Override
    public void close() {
        Misc.freeObjList(this.recordFunctions);
        Misc.free(this.base);
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        if (baseCursor.hasNext()) {
            return this.initFunctionsAndCursor(executionContext, baseCursor);
        }
        baseCursor.close();
        return EmptyTableNoSizeRecordCursor.INSTANCE;
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @NotNull
    protected RecordCursor initFunctionsAndCursor(SqlExecutionContext executionContext, RecordCursor baseCursor) {
        this.cursor.of(baseCursor, executionContext);
        Function.init(this.recordFunctions, baseCursor, executionContext);
        return this.cursor;
    }
}

