/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.groupby.AbstractVirtualRecordSampleByCursor;
import io.questdb.griffin.engine.groupby.GroupByUtils;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.ObjList;

class SampleByFillNoneRecordCursor
extends AbstractVirtualRecordSampleByCursor {
    private final Map map;
    private final RecordSink keyMapSink;
    private final RecordCursor mapCursor;

    public SampleByFillNoneRecordCursor(Map map, RecordSink keyMapSink, ObjList<GroupByFunction> groupByFunctions, ObjList<Function> recordFunctions, int timestampIndex, TimestampSampler timestampSampler) {
        super(recordFunctions, timestampIndex, timestampSampler, groupByFunctions);
        this.map = map;
        this.keyMapSink = keyMapSink;
        this.record.of(map.getRecord());
        this.mapCursor = map.getCursor();
    }

    @Override
    public boolean hasNext() {
        return this.mapHasNext() || this.baseRecord != null && this.computeNextBatch();
    }

    @Override
    public void toTop() {
        super.toTop();
        if (this.base.hasNext()) {
            this.baseRecord = this.base.getRecord();
            this.lastTimestamp = this.nextTimestamp = this.timestampSampler.round(this.baseRecord.getTimestamp(this.timestampIndex));
            this.map.clear();
        }
    }

    private boolean computeNextBatch() {
        this.lastTimestamp = this.nextTimestamp;
        this.map.clear();
        int n = this.groupByFunctions.size();
        do {
            long timestamp;
            if (this.lastTimestamp != (timestamp = this.getBaseRecordTimestamp())) {
                this.nextTimestamp = timestamp;
                GroupByUtils.toTop(this.groupByFunctions);
                return this.createMapCursor();
            }
            MapKey key = this.map.withKey();
            this.keyMapSink.copy(this.baseRecord, key);
            GroupByUtils.updateFunctions(this.groupByFunctions, n, key.createValue(), this.baseRecord);
            this.interruptor.checkInterrupted();
        } while (this.base.hasNext());
        this.baseRecord = null;
        return this.createMapCursor();
    }

    private boolean createMapCursor() {
        this.map.getCursor();
        return this.mapHasNext();
    }

    private boolean mapHasNext() {
        return this.mapCursor.hasNext();
    }
}

