/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.EmptyTableNoSizeRecordCursor;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.groupby.SampleByFillNullRecordCursorFactory;
import io.questdb.griffin.engine.groupby.SampleByFillValueNotKeyedRecordCursor;
import io.questdb.griffin.engine.groupby.SimpleMapValue;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class SampleByFillNullNotKeyedRecordCursorFactory
implements RecordCursorFactory {
    protected final RecordCursorFactory base;
    private final SampleByFillValueNotKeyedRecordCursor cursor;
    private final ObjList<Function> recordFunctions;
    private final RecordMetadata metadata;

    public SampleByFillNullNotKeyedRecordCursorFactory(RecordCursorFactory base, @NotNull TimestampSampler timestampSampler, RecordMetadata groupByMetadata, ObjList<GroupByFunction> groupByFunctions, ObjList<Function> recordFunctions, int valueCount, int timestampIndex) throws SqlException {
        try {
            this.base = base;
            this.metadata = groupByMetadata;
            this.recordFunctions = recordFunctions;
            SimpleMapValue simpleMapValue = new SimpleMapValue(valueCount);
            this.cursor = new SampleByFillValueNotKeyedRecordCursor(groupByFunctions, recordFunctions, SampleByFillNullRecordCursorFactory.createPlaceholderFunctions(recordFunctions), timestampIndex, timestampSampler, simpleMapValue);
        }
        catch (CairoException | SqlException e) {
            Misc.freeObjList(recordFunctions);
            throw e;
        }
    }

    @Override
    public void close() {
        Misc.freeObjList(this.recordFunctions);
        Misc.free(this.base);
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        if (baseCursor.hasNext()) {
            return this.initFunctionsAndCursor(executionContext, baseCursor);
        }
        Misc.free(baseCursor);
        return EmptyTableNoSizeRecordCursor.INSTANCE;
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @NotNull
    protected RecordCursor initFunctionsAndCursor(SqlExecutionContext executionContext, RecordCursor baseCursor) {
        this.cursor.of(baseCursor, executionContext);
        Function.init(this.recordFunctions, baseCursor, executionContext);
        return this.cursor;
    }
}

