/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.sql.Function;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.groupby.AbstractVirtualRecordSampleByCursor;
import io.questdb.griffin.engine.groupby.GroupByUtils;
import io.questdb.griffin.engine.groupby.SimpleMapValue;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.ObjList;

public class SampleByFillPrevNotKeyedRecordCursor
extends AbstractVirtualRecordSampleByCursor {
    private final SimpleMapValue simpleMapValue;

    public SampleByFillPrevNotKeyedRecordCursor(ObjList<GroupByFunction> groupByFunctions, ObjList<Function> recordFunctions, int timestampIndex, TimestampSampler timestampSampler, SimpleMapValue simpleMapValue) {
        super(recordFunctions, timestampIndex, timestampSampler, groupByFunctions);
        this.simpleMapValue = simpleMapValue;
        this.record.of(simpleMapValue);
    }

    @Override
    public boolean hasNext() {
        if (this.baseRecord == null) {
            return false;
        }
        long nextTimestamp = this.timestampSampler.nextTimestamp(this.lastTimestamp);
        if (this.nextTimestamp > nextTimestamp) {
            this.lastTimestamp = nextTimestamp;
            return true;
        }
        this.lastTimestamp = this.getBaseRecordTimestamp();
        int n = this.groupByFunctions.size();
        for (int i = 0; i < n; ++i) {
            ((GroupByFunction)this.groupByFunctions.getQuick(i)).computeFirst(this.simpleMapValue, this.baseRecord);
        }
        while (this.base.hasNext()) {
            this.interruptor.checkInterrupted();
            long timestamp = this.getBaseRecordTimestamp();
            if (this.lastTimestamp == timestamp) {
                for (int i = 0; i < n; ++i) {
                    ((GroupByFunction)this.groupByFunctions.getQuick(i)).computeNext(this.simpleMapValue, this.baseRecord);
                }
                continue;
            }
            this.nextTimestamp = timestamp;
            GroupByUtils.toTop(this.groupByFunctions);
            return true;
        }
        this.baseRecord = null;
        return true;
    }

    @Override
    public void toTop() {
        super.toTop();
        if (this.base.hasNext()) {
            this.baseRecord = this.base.getRecord();
            this.lastTimestamp = this.nextTimestamp = this.timestampSampler.round(this.baseRecord.getTimestamp(this.timestampIndex));
        }
    }
}

