/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapRecord;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.groupby.AbstractVirtualRecordSampleByCursor;
import io.questdb.griffin.engine.groupby.GroupByUtils;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.ObjList;

class SampleByFillPrevRecordCursor
extends AbstractVirtualRecordSampleByCursor {
    private final Map map;
    private final RecordSink keyMapSink;
    private final RecordCursor mapCursor;

    public SampleByFillPrevRecordCursor(Map map, RecordSink keyMapSink, ObjList<GroupByFunction> groupByFunctions, ObjList<Function> recordFunctions, int timestampIndex, TimestampSampler timestampSampler) {
        super(recordFunctions, timestampIndex, timestampSampler, groupByFunctions);
        this.map = map;
        this.keyMapSink = keyMapSink;
        this.mapCursor = map.getCursor();
        this.record.of(map.getRecord());
    }

    @Override
    public boolean hasNext() {
        block10: {
            long timestamp;
            block9: {
                if (this.mapCursor.hasNext()) {
                    return true;
                }
                if (this.baseRecord == null) {
                    return false;
                }
                long nextTimestamp = this.timestampSampler.nextTimestamp(this.lastTimestamp);
                if (this.nextTimestamp > nextTimestamp) {
                    this.lastTimestamp = nextTimestamp;
                    return this.map.getCursor().hasNext();
                }
                this.lastTimestamp = this.nextTimestamp;
                int n = this.groupByFunctions.size();
                do {
                    int i;
                    this.interruptor.checkInterrupted();
                    timestamp = this.getBaseRecordTimestamp();
                    if (this.lastTimestamp != timestamp) break block9;
                    MapKey key = this.map.withKey();
                    this.keyMapSink.copy(this.baseRecord, key);
                    MapValue value = key.findValue();
                    assert (value != null);
                    if (value.getLong(0) != timestamp) {
                        value.putLong(0, timestamp);
                        for (i = 0; i < n; ++i) {
                            ((GroupByFunction)this.groupByFunctions.getQuick(i)).computeFirst(value, this.baseRecord);
                        }
                    } else {
                        for (i = 0; i < n; ++i) {
                            ((GroupByFunction)this.groupByFunctions.getQuick(i)).computeNext(value, this.baseRecord);
                        }
                    }
                } while (this.base.hasNext());
                this.baseRecord = null;
                break block10;
            }
            this.nextTimestamp = timestamp;
            GroupByUtils.toTop(this.groupByFunctions);
        }
        return this.map.getCursor().hasNext();
    }

    @Override
    public void toTop() {
        super.toTop();
        if (this.base.hasNext()) {
            this.baseRecord = this.base.getRecord();
            this.lastTimestamp = this.nextTimestamp = this.timestampSampler.round(this.baseRecord.getTimestamp(this.timestampIndex));
            int n = this.groupByFunctions.size();
            RecordCursor mapCursor = this.map.getCursor();
            MapRecord mapRecord = this.map.getRecord();
            while (mapCursor.hasNext()) {
                MapValue value = mapRecord.getValue();
                value.putLong(0, Long.MIN_VALUE);
                for (int i = 0; i < n; ++i) {
                    ((GroupByFunction)this.groupByFunctions.getQuick(i)).setNull(value);
                }
            }
        }
    }
}

