/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.groupby.AbstractSplitVirtualRecordSampleByCursor;
import io.questdb.griffin.engine.groupby.GroupByUtils;
import io.questdb.griffin.engine.groupby.SimpleMapValue;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.ObjList;

public class SampleByFillValueNotKeyedRecordCursor
extends AbstractSplitVirtualRecordSampleByCursor {
    private final SimpleMapValue simpleMapValue;

    public SampleByFillValueNotKeyedRecordCursor(ObjList<GroupByFunction> groupByFunctions, ObjList<Function> recordFunctions, ObjList<Function> placeholderFunctions, int timestampIndex, TimestampSampler timestampSampler, SimpleMapValue simpleMapValue) {
        super(recordFunctions, timestampIndex, timestampSampler, groupByFunctions, placeholderFunctions);
        this.simpleMapValue = simpleMapValue;
        this.record.of(simpleMapValue);
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public boolean hasNext() {
        if (this.baseRecord == null) {
            return false;
        }
        long nextTimestamp = this.timestampSampler.nextTimestamp(this.lastTimestamp);
        if (this.nextTimestamp > nextTimestamp) {
            this.lastTimestamp = nextTimestamp;
            this.record.setActiveB();
            return true;
        }
        this.lastTimestamp = this.timestampSampler.round(this.baseRecord.getTimestamp(this.timestampIndex));
        this.record.setActiveA();
        int n = this.groupByFunctions.size();
        for (int i = 0; i < n; ++i) {
            this.interruptor.checkInterrupted();
            ((GroupByFunction)this.groupByFunctions.getQuick(i)).computeFirst(this.simpleMapValue, this.baseRecord);
        }
        while (this.base.hasNext()) {
            long timestamp = this.getBaseRecordTimestamp();
            if (this.lastTimestamp == timestamp) {
                for (int i = 0; i < n; ++i) {
                    this.interruptor.checkInterrupted();
                    ((GroupByFunction)this.groupByFunctions.getQuick(i)).computeNext(this.simpleMapValue, this.baseRecord);
                }
                continue;
            }
            this.nextTimestamp = timestamp;
            GroupByUtils.toTop(this.groupByFunctions);
            return true;
        }
        this.baseRecord = null;
        return true;
    }

    @Override
    public void toTop() {
        super.toTop();
        if (this.base.hasNext()) {
            this.baseRecord = this.base.getRecord();
            this.lastTimestamp = this.nextTimestamp = this.timestampSampler.round(this.baseRecord.getTimestamp(this.timestampIndex));
        }
    }
}

