/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.map.MapValue;

public class SimpleMapValue
implements MapValue {
    private final long[] values;

    public SimpleMapValue(int columnCount) {
        this.values = new long[columnCount];
    }

    @Override
    public long getAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getBool(int index) {
        return this.values[index] == 0L;
    }

    @Override
    public byte getByte(int index) {
        return (byte)this.values[index];
    }

    @Override
    public long getDate(int index) {
        return this.values[index];
    }

    @Override
    public double getDouble(int index) {
        return Double.longBitsToDouble(this.values[index]);
    }

    @Override
    public float getFloat(int index) {
        return Float.intBitsToFloat((int)this.values[index]);
    }

    @Override
    public char getChar(int index) {
        return (char)this.values[index];
    }

    @Override
    public int getInt(int index) {
        return (int)this.values[index];
    }

    @Override
    public long getLong(int index) {
        return this.values[index];
    }

    @Override
    public short getShort(int index) {
        return (short)this.values[index];
    }

    @Override
    public long getTimestamp(int index) {
        return this.values[index];
    }

    @Override
    public boolean isNew() {
        return false;
    }

    @Override
    public void putBool(int index, boolean value) {
        this.values[index] = value ? 0L : 1L;
    }

    @Override
    public void putByte(int index, byte value) {
        this.values[index] = value;
    }

    @Override
    public void addByte(int index, byte value) {
        int n = index;
        this.values[n] = this.values[n] + (long)value;
    }

    @Override
    public void putDate(int index, long value) {
        this.values[index] = value;
    }

    @Override
    public void putDouble(int index, double value) {
        this.values[index] = Double.doubleToLongBits(value);
    }

    @Override
    public void addDouble(int index, double value) {
        double d = Double.longBitsToDouble(this.values[index]);
        this.values[index] = Double.doubleToLongBits(value + d);
    }

    @Override
    public void putFloat(int index, float value) {
        this.values[index] = Float.floatToIntBits(value);
    }

    @Override
    public void addFloat(int index, float value) {
        float d = Float.intBitsToFloat((int)this.values[index]);
        this.values[index] = Float.floatToIntBits(value + d);
    }

    @Override
    public void putInt(int index, int value) {
        this.values[index] = value;
    }

    @Override
    public void addInt(int index, int value) {
        int n = index;
        this.values[n] = this.values[n] + (long)value;
    }

    @Override
    public void putLong(int index, long value) {
        this.values[index] = value;
    }

    @Override
    public void addLong(int index, long value) {
        int n = index;
        this.values[n] = this.values[n] + value;
    }

    @Override
    public void putShort(int index, short value) {
        this.values[index] = value;
    }

    @Override
    public void addShort(int index, short value) {
        int n = index;
        this.values[n] = this.values[n] + (long)value;
    }

    @Override
    public void putChar(int index, char value) {
        this.values[index] = value;
    }

    @Override
    public void putTimestamp(int index, long value) {
        this.values[index] = value;
    }

    @Override
    public void setMapRecordHere() {
        throw new UnsupportedOperationException();
    }
}

