/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.std.Rosti;
import io.questdb.std.Unsafe;
import java.util.concurrent.atomic.LongAdder;

public class CountVectorAggregateFunction
extends LongFunction
implements VectorAggregateFunction {
    private final LongAdder count = new LongAdder();
    private final CountFunc countFunc;
    private final int sizeBits;
    private int valueOffset;

    public CountVectorAggregateFunction(int position, int keyKind, int sizeBits) {
        super(position);
        this.sizeBits = sizeBits;
        this.countFunc = keyKind == 1 ? Rosti::keyedHourCount : Rosti::keyedIntCount;
    }

    @Override
    public void aggregate(long address, long addressSize, int workerId) {
        this.count.add(addressSize >>> this.sizeBits);
    }

    @Override
    public void aggregate(long pRosti, long keyAddress, long valueAddress, long valueAddressSize, int workerId) {
        this.countFunc.count(pRosti, keyAddress, valueAddressSize >>> this.sizeBits, this.valueOffset);
    }

    @Override
    public int getColumnIndex() {
        return -1;
    }

    @Override
    public int getValueOffset() {
        return this.valueOffset;
    }

    @Override
    public void initRosti(long pRosti) {
        Unsafe.getUnsafe().putLong(Rosti.getInitialValueSlot(pRosti, this.valueOffset), 0L);
    }

    @Override
    public void merge(long pRostiA, long pRostiB) {
        Rosti.keyedIntCountMerge(pRostiA, pRostiB, this.valueOffset);
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes types) {
        this.valueOffset = types.getColumnCount();
        types.add(5);
    }

    @Override
    public void wrapUp(long pRosti) {
    }

    @Override
    public void clear() {
        this.count.reset();
    }

    @Override
    public long getLong(Record rec) {
        return this.count.sum();
    }

    @FunctionalInterface
    private static interface CountFunc {
        public void count(long var1, long var3, long var5, int var7);
    }
}

