/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.MessageBus;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.groupby.vect.GroupByNotKeyedVectorRecordCursorFactory;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateEntry;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SOUnboundedCountDownLatch;
import io.questdb.mp.Sequence;
import io.questdb.mp.Worker;
import io.questdb.std.BinarySequence;
import io.questdb.std.IntList;
import io.questdb.std.Long256;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectPool;
import io.questdb.std.Rosti;
import io.questdb.std.Unsafe;
import io.questdb.std.str.CharSink;
import io.questdb.tasks.VectorAggregateTask;

public class GroupByRecordCursorFactory
implements RecordCursorFactory {
    private static final Log LOG = LogFactory.getLog(GroupByRecordCursorFactory.class);
    private final RecordCursorFactory base;
    private final ObjList<VectorAggregateFunction> vafList;
    private final ObjectPool<VectorAggregateEntry> entryPool;
    private final ObjList<VectorAggregateEntry> activeEntries;
    private final SOUnboundedCountDownLatch doneLatch = new SOUnboundedCountDownLatch();
    private final RecordMetadata metadata;
    private final long[] pRosti;
    private final int keyColumnIndex;
    private final RostiRecordCursor cursor;

    public GroupByRecordCursorFactory(CairoConfiguration configuration, RecordCursorFactory base, RecordMetadata metadata, ColumnTypes columnTypes, int workerCount, ObjList<VectorAggregateFunction> vafList, int keyColumnIndexInBase, int keyColumnIndexInThisCursor, IntList symbolTableSkewIndex) {
        this.entryPool = new ObjectPool<VectorAggregateEntry>(VectorAggregateEntry::new, configuration.getGroupByPoolCapacity());
        this.activeEntries = new ObjList(configuration.getGroupByPoolCapacity());
        this.base = base;
        this.metadata = metadata;
        this.pRosti = new long[workerCount];
        int vafCount = vafList.size();
        this.vafList = new ObjList(vafCount);
        for (int i = 0; i < workerCount; ++i) {
            this.pRosti[i] = Rosti.alloc(columnTypes, configuration.getGroupByMapCapacity());
            switch (columnTypes.getColumnType(0)) {
                case 4: {
                    Unsafe.getUnsafe().putInt(Rosti.getInitialValueSlot(this.pRosti[i], 0), Integer.MIN_VALUE);
                    break;
                }
                case 11: {
                    Unsafe.getUnsafe().putInt(Rosti.getInitialValueSlot(this.pRosti[i], 0), Integer.MIN_VALUE);
                    break;
                }
            }
            for (int j = 0; j < vafCount; ++j) {
                vafList.getQuick(j).initRosti(this.pRosti[i]);
            }
        }
        long pRosti = this.pRosti[0];
        long columnOffsets = Rosti.getValueOffsets(pRosti);
        IntList columnSkewIndex = new IntList();
        GroupByRecordCursorFactory.addOffsets(columnSkewIndex, vafList, 0, keyColumnIndexInThisCursor, columnOffsets);
        columnSkewIndex.add(0);
        GroupByRecordCursorFactory.addOffsets(columnSkewIndex, vafList, keyColumnIndexInThisCursor, vafCount, columnOffsets);
        this.vafList.addAll(vafList);
        this.keyColumnIndex = keyColumnIndexInBase;
        if (symbolTableSkewIndex.size() > 0) {
            IntList symbolSkew = new IntList(symbolTableSkewIndex.size());
            symbolSkew.addAll(symbolTableSkewIndex);
            this.cursor = new RostiRecordCursor(pRosti, columnSkewIndex, symbolSkew);
        } else {
            this.cursor = new RostiRecordCursor(pRosti, columnSkewIndex, null);
        }
    }

    private static void addOffsets(IntList columnSkewIndex, ObjList<VectorAggregateFunction> vafList, int start, int end, long columnOffsets) {
        for (int i = start; i < end; ++i) {
            columnSkewIndex.add(Unsafe.getUnsafe().getInt(columnOffsets + (long)vafList.getQuick(i).getValueOffset() * 4L));
        }
    }

    @Override
    public void close() {
        Misc.freeObjList(this.vafList);
        int n = this.pRosti.length;
        for (int i = 0; i < n; ++i) {
            Rosti.free(this.pRosti[i]);
        }
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        int j;
        VectorAggregateFunction vaf;
        PageFrame frame;
        int n = this.pRosti.length;
        for (int i = 0; i < n; ++i) {
            Rosti.clear(this.pRosti[i]);
        }
        MessageBus bus = executionContext.getMessageBus();
        assert (bus != null);
        PageFrameCursor cursor = this.base.getPageFrameCursor(executionContext);
        int vafCount = this.vafList.size();
        for (int i = 0; i < vafCount; ++i) {
            this.vafList.getQuick(i).clear();
        }
        RingQueue<VectorAggregateTask> queue = bus.getVectorAggregateQueue();
        Sequence pubSeq = bus.getVectorAggregatePubSeq();
        this.entryPool.clear();
        this.activeEntries.clear();
        int queuedCount = 0;
        int ownCount = 0;
        int reclaimed = 0;
        int total = 0;
        this.doneLatch.reset();
        Thread thread = Thread.currentThread();
        int workerId = thread instanceof Worker ? ((Worker)thread).getWorkerId() : 0;
        while ((frame = cursor.next()) != null) {
            long keyAddress = frame.getPageAddress(this.keyColumnIndex);
            for (int i = 0; i < vafCount; ++i) {
                long valueAddressSize;
                long valueAddress;
                vaf = this.vafList.getQuick(i);
                int columnIndex = vaf.getColumnIndex();
                if (columnIndex > -1) {
                    valueAddress = frame.getPageAddress(columnIndex);
                    valueAddressSize = frame.getPageSize(columnIndex);
                } else {
                    valueAddress = 0L;
                    valueAddressSize = frame.getPageSize(this.keyColumnIndex);
                }
                long seq = pubSeq.next();
                if (seq < 0L) {
                    if (keyAddress == 0L) {
                        vaf.aggregate(valueAddress, valueAddressSize, workerId);
                    } else {
                        vaf.aggregate(this.pRosti[workerId], keyAddress, valueAddress, valueAddressSize, workerId);
                    }
                    ++ownCount;
                } else if (keyAddress != 0L || valueAddress != 0L) {
                    VectorAggregateEntry entry = this.entryPool.next();
                    if (keyAddress == 0L) {
                        entry.of(queuedCount++, vaf, null, 0L, valueAddress, valueAddressSize, this.doneLatch);
                    } else {
                        entry.of(queuedCount++, vaf, this.pRosti, keyAddress, valueAddress, valueAddressSize, this.doneLatch);
                    }
                    this.activeEntries.add(entry);
                    queue.get((long)seq).entry = entry;
                    pubSeq.done(seq);
                }
                ++total;
            }
        }
        reclaimed = GroupByNotKeyedVectorRecordCursorFactory.getRunWhatsLeft(queuedCount, reclaimed, workerId, this.activeEntries, this.doneLatch, LOG);
        long pRosti0 = this.pRosti[0];
        if (this.pRosti.length > 1) {
            LOG.debug().$("merging").$();
            for (j = 0; j < vafCount; ++j) {
                vaf = this.vafList.getQuick(j);
                int n2 = this.pRosti.length;
                for (int i = 1; i < n2; ++i) {
                    vaf.merge(pRosti0, this.pRosti[i]);
                }
                vaf.wrapUp(pRosti0);
            }
        } else {
            for (j = 0; j < vafCount; ++j) {
                this.vafList.getQuick(j).wrapUp(pRosti0);
            }
        }
        LOG.info().$("done [total=").$(total).$(", ownCount=").$(ownCount).$(", reclaimed=").$(reclaimed).$(", queuedCount=").$(queuedCount).$(']').$();
        return this.cursor.of(cursor);
    }

    @Override
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    private static class RostiRecordCursor
    implements RecordCursor {
        private final RostiRecord record;
        private final long pRosti;
        private final IntList symbolTableSkewIndex;
        private final IntList columnSkewIndex;
        private RostiRecord recordB;
        private long ctrlStart;
        private long ctrl;
        private long slots;
        private long shift;
        private long size;
        private long count;
        private PageFrameCursor parent;

        public RostiRecordCursor(long pRosti, IntList columnSkewIndex, IntList symbolTableSkewIndex) {
            this.pRosti = pRosti;
            this.record = new RostiRecord();
            this.symbolTableSkewIndex = symbolTableSkewIndex;
            this.columnSkewIndex = columnSkewIndex;
        }

        public RostiRecordCursor of(PageFrameCursor parent) {
            this.parent = parent;
            this.toTop();
            return this;
        }

        @Override
        public void close() {
            Misc.free(this.parent);
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            while (this.count < this.size) {
                byte b = Unsafe.getUnsafe().getByte(this.ctrl);
                if ((b & 0x80) != 0) {
                    ++this.ctrl;
                    continue;
                }
                ++this.count;
                this.record.of(this.slots + (this.ctrl - this.ctrlStart << (int)this.shift));
                ++this.ctrl;
                return true;
            }
            return false;
        }

        @Override
        public Record getRecordB() {
            if (this.recordB != null) {
                return this.recordB;
            }
            this.recordB = new RostiRecord();
            return this.recordB;
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            ((RostiRecord)record).of(atRowId);
        }

        @Override
        public void toTop() {
            this.ctrl = this.ctrlStart = Rosti.getCtrl(this.pRosti);
            this.slots = Rosti.getSlots(this.pRosti);
            this.size = Rosti.getSize(this.pRosti);
            this.shift = Rosti.getSlotShift(this.pRosti);
            this.count = 0L;
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            return this.parent.getSymbolMapReader(this.symbolTableSkewIndex.getQuick(columnIndex));
        }

        private class RostiRecord
        implements Record {
            private long pRow;

            private RostiRecord() {
            }

            public void of(long pRow) {
                this.pRow = pRow;
            }

            @Override
            public BinarySequence getBin(int col) {
                throw new UnsupportedOperationException();
            }

            @Override
            public long getBinLen(int col) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean getBool(int col) {
                throw new UnsupportedOperationException();
            }

            @Override
            public byte getByte(int col) {
                throw new UnsupportedOperationException();
            }

            @Override
            public char getChar(int col) {
                throw new UnsupportedOperationException();
            }

            @Override
            public long getDate(int col) {
                return this.getLong(col);
            }

            private long getValueOffset(int column) {
                return this.pRow + (long)RostiRecordCursor.this.columnSkewIndex.getQuick(column);
            }

            @Override
            public double getDouble(int col) {
                return Unsafe.getUnsafe().getDouble(this.getValueOffset(col));
            }

            @Override
            public float getFloat(int col) {
                return 0.0f;
            }

            @Override
            public int getInt(int col) {
                return Unsafe.getUnsafe().getInt(this.getValueOffset(col));
            }

            @Override
            public long getLong(int col) {
                return Unsafe.getUnsafe().getLong(this.getValueOffset(col));
            }

            @Override
            public void getLong256(int col, CharSink sink) {
            }

            @Override
            public Long256 getLong256A(int col) {
                return null;
            }

            @Override
            public Long256 getLong256B(int col) {
                return null;
            }

            @Override
            public long getRowId() {
                return this.pRow;
            }

            @Override
            public short getShort(int col) {
                return 0;
            }

            @Override
            public CharSequence getStr(int col) {
                return null;
            }

            @Override
            public void getStr(int col, CharSink sink) {
            }

            @Override
            public CharSequence getStrB(int col) {
                return null;
            }

            @Override
            public int getStrLen(int col) {
                return 0;
            }

            @Override
            public CharSequence getSym(int col) {
                return RostiRecordCursor.this.parent.getSymbolMapReader(RostiRecordCursor.this.symbolTableSkewIndex.getQuick(col)).valueOf(this.getInt(col));
            }

            @Override
            public CharSequence getSymB(int col) {
                return RostiRecordCursor.this.parent.getSymbolMapReader(RostiRecordCursor.this.symbolTableSkewIndex.getQuick(col)).valueBOf(this.getInt(col));
            }

            @Override
            public long getTimestamp(int col) {
                return this.getLong(col);
            }
        }
    }
}

