/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.groupby.vect.DistinctFunc;
import io.questdb.griffin.engine.groupby.vect.KeyValueFunc;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.std.Rosti;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import java.util.Arrays;

public class KSumDoubleVectorAggregateFunction
extends DoubleFunction
implements VectorAggregateFunction {
    private final int columnIndex;
    private final double[] sum;
    private final long[] count;
    private final int workerCount;
    private final DistinctFunc distinctFunc;
    private final KeyValueFunc keyValueFunc;
    private int valueOffset;

    public KSumDoubleVectorAggregateFunction(int position, int keyKind, int columnIndex, int workerCount) {
        super(position);
        this.columnIndex = columnIndex;
        this.sum = new double[workerCount * 64];
        this.count = new long[workerCount * 64];
        this.workerCount = workerCount;
        if (keyKind == 1) {
            this.distinctFunc = Rosti::keyedHourDistinct;
            this.keyValueFunc = Rosti::keyedHourKSumDouble;
        } else {
            this.keyValueFunc = Rosti::keyedIntKSumDouble;
            this.distinctFunc = Rosti::keyedIntDistinct;
        }
    }

    @Override
    public void aggregate(long address, long addressSize, int workerId) {
        double x;
        if (address != 0L && (x = Vect.sumDoubleKahan(address, addressSize / 8L)) == x) {
            int offset = workerId * 64;
            double sum = this.sum[offset];
            double y = x - this.sum[offset + 1];
            double t = sum + y;
            this.sum[offset + 1] = t - sum - y;
            this.sum[offset] = t;
            int n = offset;
            this.count[n] = this.count[n] + 1L;
        }
    }

    @Override
    public void aggregate(long pRosti, long keyAddress, long valueAddress, long valueAddressSize, int workerId) {
        if (valueAddress == 0L) {
            this.distinctFunc.run(pRosti, keyAddress, valueAddressSize / 8L);
        } else {
            this.keyValueFunc.run(pRosti, keyAddress, valueAddress, valueAddressSize / 8L, this.valueOffset);
        }
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public int getValueOffset() {
        return this.valueOffset;
    }

    @Override
    public void initRosti(long pRosti) {
        Unsafe.getUnsafe().putDouble(Rosti.getInitialValueSlot(pRosti, this.valueOffset), 0.0);
        Unsafe.getUnsafe().putDouble(Rosti.getInitialValueSlot(pRosti, this.valueOffset + 1), 0.0);
        Unsafe.getUnsafe().putLong(Rosti.getInitialValueSlot(pRosti, this.valueOffset + 2), 0L);
    }

    @Override
    public void merge(long pRostiA, long pRostiB) {
        Rosti.keyedIntKSumDoubleMerge(pRostiA, pRostiB, this.valueOffset);
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes types) {
        this.valueOffset = types.getColumnCount();
        types.add(9);
        types.add(9);
        types.add(5);
    }

    @Override
    public void wrapUp(long pRosti) {
        double sum = 0.0;
        long count = 0L;
        double c = 0.0;
        for (int i = 0; i < this.workerCount; ++i) {
            int offset = i * 64;
            double y = this.sum[offset] - c;
            double t = sum + y;
            c = t - sum - y;
            sum = t;
            count += this.count[offset];
        }
        Rosti.keyedIntKSumDoubleWrapUp(pRosti, this.valueOffset, sum, count);
    }

    @Override
    public void clear() {
        Arrays.fill(this.sum, 0.0);
        Arrays.fill(this.count, 0L);
    }

    @Override
    public double getDouble(Record rec) {
        double sum = 0.0;
        long count = 0L;
        double c = 0.0;
        for (int i = 0; i < this.workerCount; ++i) {
            int offset = i * 64;
            double y = this.sum[offset] - c;
            double t = sum + y;
            c = t - sum - y;
            sum = t;
            count += this.count[offset];
        }
        return count > 0L ? sum : Double.NaN;
    }
}

