/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.DateFunction;
import io.questdb.griffin.engine.groupby.vect.DistinctFunc;
import io.questdb.griffin.engine.groupby.vect.KeyValueFunc;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.std.Rosti;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.function.LongBinaryOperator;

public class MaxDateVectorAggregateFunction
extends DateFunction
implements VectorAggregateFunction {
    public static final LongBinaryOperator MAX = Math::max;
    private final LongAccumulator max = new LongAccumulator(MAX, Long.MIN_VALUE);
    private final int columnIndex;
    private final DistinctFunc distinctFunc;
    private final KeyValueFunc keyValueFunc;
    private int valueOffset;

    public MaxDateVectorAggregateFunction(int position, int keyKind, int columnIndex, int workerCount) {
        super(position);
        this.columnIndex = columnIndex;
        if (keyKind == 1) {
            this.distinctFunc = Rosti::keyedHourDistinct;
            this.keyValueFunc = Rosti::keyedHourMaxLong;
        } else {
            this.distinctFunc = Rosti::keyedIntDistinct;
            this.keyValueFunc = Rosti::keyedIntMaxLong;
        }
    }

    @Override
    public void aggregate(long address, long addressSize, int workerId) {
        if (address != 0L) {
            this.max.accumulate(Vect.maxLong(address, addressSize / 8L));
        }
    }

    @Override
    public void aggregate(long pRosti, long keyAddress, long valueAddress, long valueAddressSize, int workerId) {
        if (valueAddress == 0L) {
            this.distinctFunc.run(pRosti, keyAddress, valueAddressSize / 8L);
        } else {
            this.keyValueFunc.run(pRosti, keyAddress, valueAddress, valueAddressSize / 8L, this.valueOffset);
        }
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public int getValueOffset() {
        return this.valueOffset;
    }

    @Override
    public void initRosti(long pRosti) {
        Unsafe.getUnsafe().putLong(Rosti.getInitialValueSlot(pRosti, this.valueOffset), Long.MIN_VALUE);
    }

    @Override
    public void merge(long pRostiA, long pRostiB) {
        Rosti.keyedIntMaxLongMerge(pRostiA, pRostiB, this.valueOffset);
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes types) {
        this.valueOffset = types.getColumnCount();
        types.add(5);
    }

    @Override
    public void wrapUp(long pRosti) {
        Rosti.keyedIntMaxLongWrapUp(pRosti, this.valueOffset, this.max.longValue());
    }

    @Override
    public void clear() {
        this.max.reset();
    }

    @Override
    public long getDate(Record rec) {
        return this.max.longValue();
    }
}

