/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.IntFunction;
import io.questdb.griffin.engine.groupby.vect.DistinctFunc;
import io.questdb.griffin.engine.groupby.vect.KeyValueFunc;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.std.Rosti;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.function.LongBinaryOperator;

public class MinIntVectorAggregateFunction
extends IntFunction
implements VectorAggregateFunction {
    public static final LongBinaryOperator MIN = Math::min;
    private final LongAccumulator accumulator = new LongAccumulator(MIN, Integer.MAX_VALUE);
    private final int columnIndex;
    private final DistinctFunc distinctFunc;
    private final KeyValueFunc keyValueFunc;
    private int valueOffset;

    public MinIntVectorAggregateFunction(int position, int keyKind, int columnIndex, int workerCount) {
        super(position);
        this.columnIndex = columnIndex;
        if (keyKind == 1) {
            this.distinctFunc = Rosti::keyedHourDistinct;
            this.keyValueFunc = Rosti::keyedHourMinInt;
        } else {
            this.distinctFunc = Rosti::keyedIntDistinct;
            this.keyValueFunc = Rosti::keyedIntMinInt;
        }
    }

    @Override
    public void aggregate(long address, long addressSize, int workerId) {
        int value;
        if (address != 0L && (value = Vect.minInt(address, addressSize / 4L)) != Integer.MIN_VALUE) {
            this.accumulator.accumulate(value);
        }
    }

    @Override
    public void aggregate(long pRosti, long keyAddress, long valueAddress, long valueAddressSize, int workerId) {
        if (valueAddress == 0L) {
            this.distinctFunc.run(pRosti, keyAddress, valueAddressSize / 4L);
        } else {
            this.keyValueFunc.run(pRosti, keyAddress, valueAddress, valueAddressSize / 4L, this.valueOffset);
        }
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public int getValueOffset() {
        return this.valueOffset;
    }

    @Override
    public void initRosti(long pRosti) {
        Unsafe.getUnsafe().putInt(Rosti.getInitialValueSlot(pRosti, this.valueOffset), Integer.MAX_VALUE);
    }

    @Override
    public void merge(long pRostiA, long pRostiB) {
        Rosti.keyedIntMinIntMerge(pRostiA, pRostiB, this.valueOffset);
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes types) {
        this.valueOffset = types.getColumnCount();
        types.add(4);
    }

    @Override
    public void wrapUp(long pRosti) {
        Rosti.keyedIntMinIntWrapUp(pRosti, this.valueOffset, this.accumulator.intValue());
    }

    @Override
    public void clear() {
        this.accumulator.reset();
    }

    @Override
    public int getInt(Record rec) {
        int value = this.accumulator.intValue();
        return value == Integer.MAX_VALUE ? Integer.MIN_VALUE : value;
    }
}

