/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.griffin.engine.groupby.vect.DistinctFunc;
import io.questdb.griffin.engine.groupby.vect.KeyValueFunc;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.std.Rosti;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.function.LongBinaryOperator;

public class MinLongVectorAggregateFunction
extends LongFunction
implements VectorAggregateFunction {
    public static final LongBinaryOperator MIN = Math::min;
    private final LongAccumulator accumulator = new LongAccumulator(MIN, Long.MAX_VALUE);
    private final int columnIndex;
    private final DistinctFunc distinctFunc;
    private final KeyValueFunc keyValueFunc;
    private int valueOffset;

    public MinLongVectorAggregateFunction(int position, int keyKind, int columnIndex, int workerCount) {
        super(position);
        this.columnIndex = columnIndex;
        if (keyKind == 1) {
            this.distinctFunc = Rosti::keyedHourDistinct;
            this.keyValueFunc = Rosti::keyedHourMinLong;
        } else {
            this.distinctFunc = Rosti::keyedIntDistinct;
            this.keyValueFunc = Rosti::keyedIntMinLong;
        }
    }

    @Override
    public void aggregate(long address, long addressSize, int workerId) {
        long value;
        if (address != 0L && (value = Vect.minLong(address, addressSize / 8L)) != Long.MIN_VALUE) {
            this.accumulator.accumulate(value);
        }
    }

    @Override
    public void aggregate(long pRosti, long keyAddress, long valueAddress, long valueAddressSize, int workerId) {
        if (valueAddress == 0L) {
            this.distinctFunc.run(pRosti, keyAddress, valueAddressSize / 8L);
        } else {
            this.keyValueFunc.run(pRosti, keyAddress, valueAddress, valueAddressSize / 8L, this.valueOffset);
        }
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public int getValueOffset() {
        return this.valueOffset;
    }

    @Override
    public void initRosti(long pRosti) {
        Unsafe.getUnsafe().putLong(Rosti.getInitialValueSlot(pRosti, this.valueOffset), Long.MAX_VALUE);
    }

    @Override
    public void merge(long pRostiA, long pRostiB) {
        Rosti.keyedIntMinLongMerge(pRostiA, pRostiB, this.valueOffset);
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes types) {
        this.valueOffset = types.getColumnCount();
        types.add(5);
    }

    @Override
    public void wrapUp(long pRosti) {
        Rosti.keyedIntMinLongWrapUp(pRosti, this.valueOffset, this.accumulator.longValue());
    }

    @Override
    public void clear() {
        this.accumulator.reset();
    }

    @Override
    public long getLong(Record rec) {
        long value = this.accumulator.longValue();
        return value == Long.MAX_VALUE ? Long.MIN_VALUE : value;
    }
}

