/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.mp.CountDownLatchSPI;
import io.questdb.std.AbstractLockable;
import io.questdb.std.Mutable;

public class VectorAggregateEntry
extends AbstractLockable
implements Mutable {
    private long[] pRosti;
    private long keyAddress;
    private long valueAddress;
    private long valueCount;
    private VectorAggregateFunction func;
    private CountDownLatchSPI doneLatch;

    @Override
    public void clear() {
        this.valueAddress = 0L;
        this.valueCount = 0L;
        this.func = null;
    }

    public boolean run(int workerId) {
        if (this.tryLock()) {
            if (this.pRosti != null) {
                this.func.aggregate(this.pRosti[workerId], this.keyAddress, this.valueAddress, this.valueCount, workerId);
            } else {
                this.func.aggregate(this.valueAddress, this.valueCount, workerId);
            }
            this.doneLatch.countDown();
            return true;
        }
        return false;
    }

    void of(int sequence, VectorAggregateFunction vaf, long[] pRosti, long keyPageAddress, long valuePageAddress, long valuePageCount, CountDownLatchSPI doneLatch) {
        this.of(sequence);
        this.pRosti = pRosti;
        this.keyAddress = keyPageAddress;
        this.valueAddress = valuePageAddress;
        this.valueCount = valuePageCount;
        this.func = vaf;
        this.doneLatch = doneLatch;
    }
}

