/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.EmptyTableRecordCursor;
import io.questdb.griffin.engine.join.JoinRecord;
import io.questdb.griffin.engine.join.JoinRecordMetadata;
import io.questdb.std.Misc;

public class CrossJoinRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final RecordCursorFactory masterFactory;
    private final RecordCursorFactory slaveFactory;
    private final CrossJoinRecordCursor cursor;

    public CrossJoinRecordCursorFactory(RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, int columnSplit) {
        super(metadata);
        this.masterFactory = masterFactory;
        this.slaveFactory = slaveFactory;
        this.cursor = new CrossJoinRecordCursor(columnSplit);
    }

    @Override
    public void close() {
        ((JoinRecordMetadata)this.getMetadata()).close();
        this.masterFactory.close();
        this.slaveFactory.close();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        RecordCursor masterCursor = this.masterFactory.getCursor(executionContext);
        RecordCursor slaveCursor = this.slaveFactory.getCursor(executionContext);
        if (masterCursor.hasNext()) {
            this.cursor.of(masterCursor, slaveCursor);
            return this.cursor;
        }
        return EmptyTableRecordCursor.INSTANCE;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    private static class CrossJoinRecordCursor
    implements NoRandomAccessRecordCursor {
        private final JoinRecord record;
        private final int columnSplit;
        private RecordCursor masterCursor;
        private RecordCursor slaveCursor;

        public CrossJoinRecordCursor(int columnSplit) {
            this.record = new JoinRecord(columnSplit);
            this.columnSplit = columnSplit;
        }

        @Override
        public void close() {
            this.masterCursor = Misc.free(this.masterCursor);
            this.slaveCursor = Misc.free(this.slaveCursor);
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            if (columnIndex < this.columnSplit) {
                return this.masterCursor.getSymbolTable(columnIndex);
            }
            return this.slaveCursor.getSymbolTable(columnIndex - this.columnSplit);
        }

        @Override
        public long size() {
            long sizeA = this.masterCursor.size();
            long sizeB = this.slaveCursor.size();
            if (sizeA == -1L || sizeB == -1L) {
                return -1L;
            }
            long result = sizeA * sizeB;
            return result < sizeA ? Long.MAX_VALUE : result;
        }

        @Override
        public boolean hasNext() {
            if (this.slaveCursor.hasNext()) {
                return true;
            }
            if (this.masterCursor.hasNext()) {
                this.slaveCursor.toTop();
                return this.slaveCursor.hasNext();
            }
            return false;
        }

        @Override
        public void toTop() {
            this.masterCursor.toTop();
            this.masterCursor.hasNext();
            this.slaveCursor.toTop();
        }

        void of(RecordCursor masterCursor, RecordCursor slaveCursor) {
            this.masterCursor = masterCursor;
            this.slaveCursor = slaveCursor;
            this.record.of(masterCursor.getRecord(), slaveCursor.getRecord());
        }
    }
}

