/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlExecutionInterruptor;
import io.questdb.griffin.engine.join.JoinRecord;
import io.questdb.griffin.engine.join.JoinRecordMetadata;
import io.questdb.griffin.engine.join.LongChain;
import io.questdb.std.Misc;

public class HashJoinLightRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final Map joinKeyMap;
    private final LongChain slaveChain;
    private final RecordCursorFactory masterFactory;
    private final RecordCursorFactory slaveFactory;
    private final RecordSink masterKeySink;
    private final RecordSink slaveKeySink;
    private final HashJoinRecordCursor cursor;

    public HashJoinLightRecordCursorFactory(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, ColumnTypes joinColumnTypes, ColumnTypes valueTypes, RecordSink masterKeySink, RecordSink slaveKeySink, int columnSplit) {
        super(metadata);
        this.masterFactory = masterFactory;
        this.slaveFactory = slaveFactory;
        this.joinKeyMap = MapFactory.createMap(configuration, joinColumnTypes, valueTypes);
        this.slaveChain = new LongChain(configuration.getSqlHashJoinLightValuePageSize(), configuration.getSqlHashJoinLightValueMaxPages());
        this.masterKeySink = masterKeySink;
        this.slaveKeySink = slaveKeySink;
        this.cursor = new HashJoinRecordCursor(columnSplit, this.joinKeyMap, this.slaveChain);
    }

    @Override
    public void close() {
        this.joinKeyMap.close();
        this.slaveChain.close();
        ((JoinRecordMetadata)this.getMetadata()).close();
        this.masterFactory.close();
        this.slaveFactory.close();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        RecordCursor slaveCursor = this.slaveFactory.getCursor(executionContext);
        try {
            this.buildMapOfSlaveRecords(slaveCursor, executionContext.getSqlExecutionInterruptor());
        }
        catch (Throwable e) {
            slaveCursor.close();
            throw e;
        }
        this.cursor.of(this.masterFactory.getCursor(executionContext), slaveCursor);
        return this.cursor;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    private void buildMapOfSlaveRecords(RecordCursor slaveCursor, SqlExecutionInterruptor interruptor) {
        this.slaveChain.clear();
        this.joinKeyMap.clear();
        Record record = slaveCursor.getRecord();
        while (slaveCursor.hasNext()) {
            interruptor.checkInterrupted();
            MapKey key = this.joinKeyMap.withKey();
            key.put(record, this.slaveKeySink);
            MapValue value = key.createValue();
            if (value.isNew()) {
                long offset = this.slaveChain.put(record.getRowId(), -1L);
                value.putLong(0, offset);
                value.putLong(1, offset);
                continue;
            }
            value.putLong(1, this.slaveChain.put(record.getRowId(), value.getLong(1)));
        }
    }

    private class HashJoinRecordCursor
    implements NoRandomAccessRecordCursor {
        private final JoinRecord record;
        private final LongChain slaveChain;
        private final Map joinKeyMap;
        private final int columnSplit;
        private RecordCursor masterCursor;
        private RecordCursor slaveCursor;
        private Record masterRecord;
        private LongChain.TreeCursor slaveChainCursor;
        private Record slaveRecord;

        public HashJoinRecordCursor(int columnSplit, Map joinKeyMap, LongChain slaveChain) {
            this.record = new JoinRecord(columnSplit);
            this.joinKeyMap = joinKeyMap;
            this.slaveChain = slaveChain;
            this.columnSplit = columnSplit;
        }

        @Override
        public void close() {
            this.masterCursor = Misc.free(this.masterCursor);
            this.slaveCursor = Misc.free(this.slaveCursor);
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            if (columnIndex < this.columnSplit) {
                return this.masterCursor.getSymbolTable(columnIndex);
            }
            return this.slaveCursor.getSymbolTable(columnIndex - this.columnSplit);
        }

        @Override
        public long size() {
            return -1L;
        }

        @Override
        public void toTop() {
            this.masterCursor.toTop();
            this.slaveChainCursor = null;
        }

        @Override
        public boolean hasNext() {
            if (this.slaveChainCursor != null && this.slaveChainCursor.hasNext()) {
                this.slaveCursor.recordAt(this.slaveRecord, this.slaveChainCursor.next());
                return true;
            }
            while (this.masterCursor.hasNext()) {
                MapKey key = this.joinKeyMap.withKey();
                key.put(this.masterRecord, HashJoinLightRecordCursorFactory.this.masterKeySink);
                MapValue value = key.findValue();
                if (value == null) continue;
                this.slaveChainCursor = this.slaveChain.getCursor(value.getLong(0));
                this.slaveChainCursor.hasNext();
                this.slaveCursor.recordAt(this.slaveRecord, this.slaveChainCursor.next());
                return true;
            }
            return false;
        }

        void of(RecordCursor masterCursor, RecordCursor slaveCursor) {
            this.masterCursor = masterCursor;
            this.slaveCursor = slaveCursor;
            this.masterRecord = masterCursor.getRecord();
            this.slaveRecord = slaveCursor.getRecordB();
            this.record.of(this.masterRecord, this.slaveRecord);
            this.slaveChainCursor = null;
        }
    }
}

