/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.vm.ContiguousVirtualMemory;
import io.questdb.std.Mutable;
import java.io.Closeable;

public class LongChain
implements Closeable,
Mutable {
    private final ContiguousVirtualMemory valueChain;
    private final TreeCursor cursor;

    public LongChain(long valuePageSize, int valueMaxPages) {
        this.valueChain = new ContiguousVirtualMemory(valuePageSize, valueMaxPages);
        this.cursor = new TreeCursor();
    }

    @Override
    public void clear() {
        this.valueChain.jumpTo(0L);
    }

    @Override
    public void close() {
        this.valueChain.close();
    }

    public TreeCursor getCursor(long tailOffset) {
        this.cursor.of(tailOffset);
        return this.cursor;
    }

    public long put(long value, long parentOffset) {
        long appendOffset = this.valueChain.getAppendOffset();
        if (parentOffset != -1L) {
            this.valueChain.putLong(parentOffset, appendOffset);
        }
        this.valueChain.putLong128(-1L, value);
        return appendOffset;
    }

    public class TreeCursor {
        private long nextOffset;

        public boolean hasNext() {
            return this.nextOffset != -1L;
        }

        public long next() {
            long next = LongChain.this.valueChain.getLong(this.nextOffset);
            long value = LongChain.this.valueChain.getLong(this.nextOffset + 8L);
            this.nextOffset = next;
            return value;
        }

        void of(long startOffset) {
            this.nextOffset = startOffset;
        }
    }
}

