/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.join.JoinRecordMetadata;
import io.questdb.griffin.engine.join.NullRecordFactory;
import io.questdb.griffin.engine.join.OuterJoinRecord;
import io.questdb.std.Misc;

public class LtJoinLightRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final Map joinKeyMap;
    private final RecordCursorFactory masterFactory;
    private final RecordCursorFactory slaveFactory;
    private final RecordSink masterKeySink;
    private final RecordSink slaveKeySink;
    private final LtJoinLightRecordCursor cursor;

    public LtJoinLightRecordCursorFactory(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, ColumnTypes joinColumnTypes, ColumnTypes valueTypes, RecordSink masterKeySink, RecordSink slaveKeySink, int columnSplit) {
        super(metadata);
        this.masterFactory = masterFactory;
        this.slaveFactory = slaveFactory;
        this.joinKeyMap = MapFactory.createMap(configuration, joinColumnTypes, valueTypes);
        this.masterKeySink = masterKeySink;
        this.slaveKeySink = slaveKeySink;
        this.cursor = new LtJoinLightRecordCursor(columnSplit, this.joinKeyMap, NullRecordFactory.getInstance(slaveFactory.getMetadata()), masterFactory.getMetadata().getTimestampIndex(), slaveFactory.getMetadata().getTimestampIndex());
    }

    @Override
    public void close() {
        this.joinKeyMap.close();
        ((JoinRecordMetadata)this.getMetadata()).close();
        this.masterFactory.close();
        this.slaveFactory.close();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        this.cursor.of(this.masterFactory.getCursor(executionContext), this.slaveFactory.getCursor(executionContext));
        return this.cursor;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    private class LtJoinLightRecordCursor
    implements NoRandomAccessRecordCursor {
        private final OuterJoinRecord record;
        private final Map joinKeyMap;
        private final int columnSplit;
        private final int masterTimestampIndex;
        private final int slaveTimestampIndex;
        private Record slaveRecord;
        private RecordCursor masterCursor;
        private RecordCursor slaveCursor;
        private Record masterRecord;
        private long slaveTimestamp = Long.MIN_VALUE;
        private long lastSlaveRowID = Long.MIN_VALUE;

        public LtJoinLightRecordCursor(int columnSplit, Map joinKeyMap, Record nullRecord, int masterTimestampIndex, int slaveTimestampIndex) {
            this.record = new OuterJoinRecord(columnSplit, nullRecord);
            this.joinKeyMap = joinKeyMap;
            this.columnSplit = columnSplit;
            this.masterTimestampIndex = masterTimestampIndex;
            this.slaveTimestampIndex = slaveTimestampIndex;
        }

        @Override
        public void close() {
            this.masterCursor = Misc.free(this.masterCursor);
            this.slaveCursor = Misc.free(this.slaveCursor);
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            if (columnIndex < this.columnSplit) {
                return this.masterCursor.getSymbolTable(columnIndex);
            }
            return this.slaveCursor.getSymbolTable(columnIndex - this.columnSplit);
        }

        @Override
        public long size() {
            return this.masterCursor.size();
        }

        @Override
        public boolean hasNext() {
            if (this.masterCursor.hasNext()) {
                MapValue value;
                MapKey key;
                long slaveTimestamp = this.slaveTimestamp;
                long masterTimestamp = this.masterRecord.getTimestamp(this.masterTimestampIndex);
                if (slaveTimestamp < masterTimestamp) {
                    if (this.lastSlaveRowID != Long.MIN_VALUE) {
                        this.slaveCursor.recordAt(this.slaveRecord, this.lastSlaveRowID);
                        key = this.joinKeyMap.withKey();
                        key.put(this.slaveRecord, LtJoinLightRecordCursorFactory.this.slaveKeySink);
                        value = key.createValue();
                        value.putLong(0, this.lastSlaveRowID);
                    }
                    Record rec = this.slaveCursor.getRecord();
                    while (this.slaveCursor.hasNext() && (slaveTimestamp = rec.getTimestamp(this.slaveTimestampIndex)) < masterTimestamp) {
                        key = this.joinKeyMap.withKey();
                        key.put(rec, LtJoinLightRecordCursorFactory.this.slaveKeySink);
                        value = key.createValue();
                        value.putLong(0, rec.getRowId());
                    }
                    this.slaveTimestamp = slaveTimestamp;
                    this.lastSlaveRowID = rec.getRowId();
                }
                key = this.joinKeyMap.withKey();
                key.put(this.masterRecord, LtJoinLightRecordCursorFactory.this.masterKeySink);
                value = key.findValue();
                if (value != null) {
                    this.slaveCursor.recordAt(this.slaveRecord, value.getLong(0));
                    this.record.hasSlave(true);
                } else {
                    this.record.hasSlave(false);
                }
                return true;
            }
            return false;
        }

        @Override
        public void toTop() {
            this.joinKeyMap.clear();
            this.slaveTimestamp = Long.MIN_VALUE;
            this.lastSlaveRowID = Long.MIN_VALUE;
            this.masterCursor.toTop();
            this.slaveCursor.toTop();
        }

        void of(RecordCursor masterCursor, RecordCursor slaveCursor) {
            this.joinKeyMap.clear();
            this.slaveTimestamp = Long.MIN_VALUE;
            this.lastSlaveRowID = Long.MIN_VALUE;
            this.masterCursor = masterCursor;
            this.slaveCursor = slaveCursor;
            this.masterRecord = masterCursor.getRecord();
            this.slaveRecord = slaveCursor.getRecordB();
            this.record.of(this.masterRecord, this.slaveRecord);
        }
    }
}

